/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ResourceConfigurationParser;
import com.oracle.svm.configure.ResourcesRegistry;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import org.graalvm.collections.EconomicMap;

final class ResourceMetadataParser<C>
extends ResourceConfigurationParser<C> {
    ResourceMetadataParser(ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, EnumSet<ConfigurationParserOption> parserOptions) {
        super(conditionResolver, registry, parserOptions);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object bundlesJson;
        Object resourcesJson = this.getFromGlobalFile(json, "resources");
        if (resourcesJson != null) {
            List<Object> globsAndBundles = ResourceMetadataParser.asList(resourcesJson, "'resources' section must be a list of glob pattern or bundle descriptors");
            for (Object object : globsAndBundles) {
                EconomicMap<String, Object> globOrBundle = ResourceMetadataParser.asMap(object, "Elements of 'resources' list must be glob pattern or bundle descriptor objects");
                if (globOrBundle.containsKey((Object)"glob")) {
                    this.parseGlobEntry(object, (condition, module, glob) -> this.registry.addGlob(condition, module, glob, origin));
                    continue;
                }
                if (!globOrBundle.containsKey((Object)"bundle")) continue;
                this.parseBundle(globOrBundle, true);
            }
        }
        if ((bundlesJson = this.getFromGlobalFile(json, "bundles")) != null) {
            this.parseBundlesObject(bundlesJson);
        }
    }

    @Override
    protected UnresolvedConfigurationCondition parseCondition(EconomicMap<String, Object> condition) {
        return this.parseCondition(condition, true);
    }
}

