/*
 * Copyright (c) 2013, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.objectfile;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WriteLayout implements Map<ObjectFile.Element, LayoutDecisionMap> {

    private HashMap<ObjectFile.Element, LayoutDecisionMap> map;

    // clone constructor
    @SuppressWarnings("unchecked")
    private WriteLayout(HashMap<ObjectFile.Element, LayoutDecisionMap> in) {
        this.map = (HashMap<ObjectFile.Element, LayoutDecisionMap>) in.clone();
    }

    public WriteLayout() {
        this.map = new HashMap<>();
    }

    @Override
    public void clear() {
        map.clear();
    }

    @Override
    public Object clone() {
        return new WriteLayout(map); // clone happens in callee constructor
    }

    /*
     * The following delegate methods are generated by Eclipse, and can be regenerated if the data
     * type of map needs to be changed.
     */

    @Override
    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return map.containsValue(arg0);
    }

    @Override
    public Set<Map.Entry<ObjectFile.Element, LayoutDecisionMap>> entrySet() {
        return map.entrySet();
    }

    public LayoutDecisionMap getOrCreate(ObjectFile.Element key) {
        LayoutDecisionMap m = map.get(key);
        if (m == null) {
            m = new LayoutDecisionMap(key);
            this.put(key, m);
        }
        return m;
    }

    @Override
    public boolean equals(Object arg0) {
        return map.equals(arg0);
    }

    @Override
    public LayoutDecisionMap get(Object key) {
        return map.get(key);
    }

    @Override
    public int hashCode() {
        return map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return map.isEmpty();
    }

    @Override
    public Set<ObjectFile.Element> keySet() {
        return map.keySet();
    }

    @Override
    public LayoutDecisionMap put(ObjectFile.Element arg0, LayoutDecisionMap arg1) {
        return map.put(arg0, arg1);
    }

    @Override
    public void putAll(Map<? extends ObjectFile.Element, ? extends LayoutDecisionMap> arg0) {
        map.putAll(arg0);
    }

    @Override
    public LayoutDecisionMap remove(Object key) {
        return map.remove(key);
    }

    @Override
    public int size() {
        return map.size();
    }

    @Override
    public String toString() {
        return map.toString();
    }

    @Override
    public Collection<LayoutDecisionMap> values() {
        return map.values();
    }
}
