// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: TruffleFeature.Options.java
package com.oracle.svm.truffle;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class TruffleFeature_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(TruffleFeature.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "PrintStaticTruffleBoundaries": {
            return OptionDescriptor.create(
                /*name*/ "PrintStaticTruffleBoundaries",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print truffle boundaries found during the analysis",
                /*container*/ getContainer(),
                /*option*/ TruffleFeature.Options.PrintStaticTruffleBoundaries,
                /*fieldName*/ "PrintStaticTruffleBoundaries",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleCheckBlackListedMethods": {
            return OptionDescriptor.create(
                /*name*/ "TruffleCheckBlackListedMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fail if a method known as not suitable for partial evaluation is reachable for runtime compilation",
                /*container*/ getContainer(),
                /*option*/ TruffleFeature.Options.TruffleCheckBlackListedMethods,
                /*fieldName*/ "TruffleCheckBlackListedMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "TruffleCheckBlockListMethods": {
            return OptionDescriptor.create(
                /*name*/ "TruffleCheckBlockListMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fail if a method known as not suitable for partial evaluation is reachable for runtime compilation",
                /*container*/ getContainer(),
                /*option*/ TruffleFeature.Options.TruffleCheckBlockListMethods,
                /*fieldName*/ "TruffleCheckBlockListMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleCheckFrameImplementation": {
            return OptionDescriptor.create(
                /*name*/ "TruffleCheckFrameImplementation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enforce that the Truffle runtime provides the only implementation of Frame",
                /*container*/ getContainer(),
                /*option*/ TruffleFeature.Options.TruffleCheckFrameImplementation,
                /*fieldName*/ "TruffleCheckFrameImplementation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleCheckNeverPartOfCompilation": {
            return OptionDescriptor.create(
                /*name*/ "TruffleCheckNeverPartOfCompilation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Check that CompilerAsserts.neverPartOfCompilation is not reachable for runtime compilation",
                /*container*/ getContainer(),
                /*option*/ TruffleFeature.Options.TruffleCheckNeverPartOfCompilation,
                /*fieldName*/ "TruffleCheckNeverPartOfCompilation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleInlineDuringParsing": {
            return OptionDescriptor.create(
                /*name*/ "TruffleInlineDuringParsing",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "No longer has any effect",
                /*container*/ getContainer(),
                /*option*/ TruffleFeature.Options.TruffleInlineDuringParsing,
                /*fieldName*/ "TruffleInlineDuringParsing",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 6;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("PrintStaticTruffleBoundaries");
                    case 1: return get("TruffleCheckBlackListedMethods");
                    case 2: return get("TruffleCheckBlockListMethods");
                    case 3: return get("TruffleCheckFrameImplementation");
                    case 4: return get("TruffleCheckNeverPartOfCompilation");
                    case 5: return get("TruffleInlineDuringParsing");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
