// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HotspotSnippetsOptions.java
package jdk.graal.compiler.hotspot.replacements;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class HotspotSnippetsOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(HotspotSnippetsOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "LoadExceptionObjectInVM": {
            return OptionDescriptor.create(
                /*name*/ "LoadExceptionObjectInVM",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a VM runtime call to load and clear the exception object from the thread at the start of a compiled exception handler.",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.LoadExceptionObjectInVM,
                /*fieldName*/ "LoadExceptionObjectInVM",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ProfileAllocations": {
            return OptionDescriptor.create(
                /*name*/ "ProfileAllocations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable profiling of allocation sites.",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.ProfileAllocations,
                /*fieldName*/ "ProfileAllocations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ProfileAllocationsContext": {
            return OptionDescriptor.create(
                /*name*/ "ProfileAllocationsContext",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.hotspot.replacements.HotSpotAllocationSnippets.ProfileContext.class,
                /*help*/ """
Control the naming and granularity of the counters when using ProfileAllocations.
The accepted values are:
        AllocatingMethod - a counter per method
         InstanceOrArray - one counter for all instance allocations and
                           one counter for all array allocations
           AllocatedType - one counter per allocated type
  AllocatedTypesInMethod - one counter per allocated type, per method""",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.ProfileAllocationsContext,
                /*fieldName*/ "ProfileAllocationsContext",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ProfileMonitors": {
            return OptionDescriptor.create(
                /*name*/ "ProfileMonitors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable profiling of monitor operations.",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.ProfileMonitors,
                /*fieldName*/ "ProfileMonitors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceMonitorsMethodFilter": {
            return OptionDescriptor.create(
                /*name*/ "TraceMonitorsMethodFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Trace monitor operations in methods whose fully qualified name contains this substring.",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.TraceMonitorsMethodFilter,
                /*fieldName*/ "TraceMonitorsMethodFilter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceMonitorsTypeFilter": {
            return OptionDescriptor.create(
                /*name*/ "TraceMonitorsTypeFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Trace monitor operations on objects whose type contains this substring.",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.TraceMonitorsTypeFilter,
                /*fieldName*/ "TraceMonitorsTypeFilter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyBalancedMonitors": {
            return OptionDescriptor.create(
                /*name*/ "VerifyBalancedMonitors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emit extra code to dynamically check monitor operations are balanced.",
                /*container*/ getContainer(),
                /*option*/ HotspotSnippetsOptions.VerifyBalancedMonitors,
                /*fieldName*/ "VerifyBalancedMonitors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 7;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("LoadExceptionObjectInVM");
                    case 1: return get("ProfileAllocations");
                    case 2: return get("ProfileAllocationsContext");
                    case 3: return get("ProfileMonitors");
                    case 4: return get("TraceMonitorsMethodFilter");
                    case 5: return get("TraceMonitorsTypeFilter");
                    case 6: return get("VerifyBalancedMonitors");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
