// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: BytecodeParserOptions.java
package jdk.graal.compiler.java;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class BytecodeParserOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(BytecodeParserOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "DoNotMoveAllocationsWithOOMEHandlers": {
            return OptionDescriptor.create(
                /*name*/ "DoNotMoveAllocationsWithOOMEHandlers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Do not move allocations when the parser encounters allocations covered by an exception handler for OutOfMemoryError.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.DoNotMoveAllocationsWithOOMEHandlers,
                /*fieldName*/ "DoNotMoveAllocationsWithOOMEHandlers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpAfterEveryBCI": {
            return OptionDescriptor.create(
                /*name*/ "DumpAfterEveryBCI",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dump the current graph after every bci to IGV.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.DumpAfterEveryBCI,
                /*fieldName*/ "DumpAfterEveryBCI",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineDuringParsing": {
            return OptionDescriptor.create(
                /*name*/ "InlineDuringParsing",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inlines trivial methods during bytecode parsing.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.InlineDuringParsing,
                /*fieldName*/ "InlineDuringParsing",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineDuringParsingMaxDepth": {
            return OptionDescriptor.create(
                /*name*/ "InlineDuringParsingMaxDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum depth when inlining during bytecode parsing.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.InlineDuringParsingMaxDepth,
                /*fieldName*/ "InlineDuringParsingMaxDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlinePartialIntrinsicExitDuringParsing": {
            return OptionDescriptor.create(
                /*name*/ "InlinePartialIntrinsicExitDuringParsing",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inlines partial intrinsic exits during bytecode parsing when possible. A partial intrinsic exit is a call within an intrinsic to the method being intrinsified and denotes semantics of the original method that the intrinsic does not support.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.InlinePartialIntrinsicExitDuringParsing,
                /*fieldName*/ "InlinePartialIntrinsicExitDuringParsing",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParserCreateProxies": {
            return OptionDescriptor.create(
                /*name*/ "ParserCreateProxies",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Introduce proxies in the parser.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.ParserCreateProxies,
                /*fieldName*/ "ParserCreateProxies",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceBytecodeParserLevel": {
            return OptionDescriptor.create(
                /*name*/ "TraceBytecodeParserLevel",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The trace level for the bytecode parser. A value of 1 enables instruction tracing and any greater value emits a frame state trace just prior to each instruction trace.Instruction tracing output from multiple compiler threads will be interleaved so use of this option make most sense for single threaded compilation. The MethodFilter option can be used to refine tracing to selected methods.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.TraceBytecodeParserLevel,
                /*fieldName*/ "TraceBytecodeParserLevel",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInlineDuringParsing": {
            return OptionDescriptor.create(
                /*name*/ "TraceInlineDuringParsing",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Traces inlining performed during bytecode parsing.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.TraceInlineDuringParsing,
                /*fieldName*/ "TraceInlineDuringParsing",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceParserPlugins": {
            return OptionDescriptor.create(
                /*name*/ "TraceParserPlugins",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Traces use of plugins during bytecode parsing.",
                /*container*/ getContainer(),
                /*option*/ BytecodeParserOptions.TraceParserPlugins,
                /*fieldName*/ "TraceParserPlugins",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 9;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("DoNotMoveAllocationsWithOOMEHandlers");
                    case 1: return get("DumpAfterEveryBCI");
                    case 2: return get("InlineDuringParsing");
                    case 3: return get("InlineDuringParsingMaxDepth");
                    case 4: return get("InlinePartialIntrinsicExitDuringParsing");
                    case 5: return get("ParserCreateProxies");
                    case 6: return get("TraceBytecodeParserLevel");
                    case 7: return get("TraceInlineDuringParsing");
                    case 8: return get("TraceParserPlugins");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
