// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: BasePhase.PhaseOptions.java
package jdk.graal.compiler.phases;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class BasePhase_PhaseOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(BasePhase.PhaseOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "CompilationExcludePhases": {
            return OptionDescriptor.create(
                /*name*/ "CompilationExcludePhases",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Exclude certain phases from compilation based on the given phase filter(s).
A phase filter is a phase name, optionally followed by '=' and a method
filter. Multiple phase filters can be specified, separated by ':'.
A phase name is matched as a substring.

For example:

   PartialEscape:Loop=B.foo,A.*

matches PartialEscapePhase for compilation of all methods and any phase
containing \"Loop\" in its name for compilation of B.foo as well as all
methods in class A.

A phase filter specification cannot be empty. Specify \"*\" to match
any phase.""",
                /*container*/ getContainer(),
                /*option*/ BasePhase.PhaseOptions.CompilationExcludePhases,
                /*fieldName*/ "CompilationExcludePhases",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimalGraphNodeSizeCheckSize": {
            return OptionDescriptor.create(
                /*name*/ "MinimalGraphNodeSizeCheckSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Minimal size in NodeSize to check the graph size increases of phases.",
                /*container*/ getContainer(),
                /*option*/ BasePhase.PhaseOptions.MinimalGraphNodeSizeCheckSize,
                /*fieldName*/ "MinimalGraphNodeSizeCheckSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyGraalPhasesSize": {
            return OptionDescriptor.create(
                /*name*/ "VerifyGraalPhasesSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify before - after relation of the relative, computed, code size of a graph",
                /*container*/ getContainer(),
                /*option*/ BasePhase.PhaseOptions.VerifyGraalPhasesSize,
                /*fieldName*/ "VerifyGraalPhasesSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("CompilationExcludePhases");
                    case 1: return get("MinimalGraphNodeSizeCheckSize");
                    case 2: return get("VerifyGraalPhasesSize");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
