/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.BooleanInstanceOfCheckTypeFlow;
import com.oracle.graal.pointsto.flow.BooleanNullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.GlobalFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.PrimitiveTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.ClassUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.graal.compiler.graph.Node;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;

public abstract class TypeFlow<T> {
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> USE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "uses");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> INPUTS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "inputs");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> OBSERVERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "observers");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> OBSERVEES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "observees");
    private static final AtomicReferenceFieldUpdater<TypeFlow, Object> PREDICATED_FLOWS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, Object.class, "predicatedFlows");
    private static final AtomicIntegerFieldUpdater<TypeFlow> PREDICATE_TRIGGERED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TypeFlow.class, "predicateTriggered");
    private static final AtomicIntegerFieldUpdater<TypeFlow> IS_ENABLED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TypeFlow.class, "isEnabled");
    private static final AtomicReferenceFieldUpdater<TypeFlow, TypeFlow> PREDICATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, TypeFlow.class, "predicate");
    private static final AtomicIntegerFieldUpdater<TypeFlow> SATURATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TypeFlow.class, "isSaturated");
    private static final AtomicIntegerFieldUpdater<TypeFlow> INPUT_SATURATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TypeFlow.class, "inputSaturated");
    private static final AtomicIntegerFieldUpdater<TypeFlow> OBSERVED_SATURATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TypeFlow.class, "observedSaturated");
    protected static final AtomicInteger nextId = new AtomicInteger();
    protected final int id = nextId.incrementAndGet();
    protected T source;
    protected final AnalysisType declaredType;
    private volatile TypeState state;
    private volatile int isEnabled;
    private volatile TypeFlow<?> predicate;
    private volatile int predicateTriggered;
    private volatile Object uses;
    private volatile Object inputs;
    private volatile Object observers;
    private volatile Object observees;
    private volatile Object predicatedFlows;
    private int slot;
    private final boolean isClone;
    protected final MethodFlowsGraph graphRef;
    public volatile boolean inQueue;
    private volatile int isSaturated;
    private static final int SIGNAL_RECEIVED = 1;
    private static final int CALLBACK_EXECUTED = 2;
    private volatile int inputSaturated;
    private volatile int observedSaturated;
    private boolean isValid = true;
    private static final AtomicReferenceFieldUpdater<TypeFlow, TypeState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TypeFlow.class, TypeState.class, "state");
    protected final boolean isPrimitiveFlow;

    private TypeFlow(T source, AnalysisType declaredType, TypeState typeState, int slot, boolean isClone, MethodFlowsGraph graphRef) {
        this.source = source;
        this.declaredType = declaredType;
        this.slot = slot;
        this.isClone = isClone;
        this.graphRef = graphRef;
        this.state = typeState;
        this.isPrimitiveFlow = declaredType != null ? declaredType.isPrimitive() || declaredType.isWordType() : typeState.isPrimitive();
        this.validateSource();
        assert (this.primitiveFlowCheck(this.state)) : String.valueOf(this.state) + ", " + String.valueOf(this);
        if (this instanceof GlobalFlow) {
            AtomicUtils.atomicMark(this, IS_ENABLED_UPDATER);
            if (this.state.isNotEmpty()) {
                AtomicUtils.atomicMark(this, PREDICATE_TRIGGERED_UPDATER);
            }
        }
    }

    public void setPredicate(TypeFlow<?> predicate) {
        AtomicUtils.atomicSet(this, predicate, PREDICATE_UPDATER);
    }

    public TypeFlow<?> getPredicate() {
        return PREDICATE_UPDATER.get(this);
    }

    public boolean isPrimitiveFlow() {
        return this.isPrimitiveFlow;
    }

    public boolean enableFlow(PointsToAnalysis bb) {
        if (AtomicUtils.atomicMark(this, IS_ENABLED_UPDATER)) {
            if (bb != null) {
                this.onFlowEnabled(bb);
                if (INPUT_SATURATED_UPDATER.compareAndSet(this, 1, 2)) {
                    this.onInputSaturated(bb, null);
                }
                if (OBSERVED_SATURATED_UPDATER.compareAndSet(this, 1, 2)) {
                    this.onObservedSaturated(bb, null);
                }
            }
            return true;
        }
        return false;
    }

    protected void onFlowEnabled(PointsToAnalysis bb) {
        if (this.state.isNotEmpty()) {
            this.propagateState(bb, true, this.state);
        }
    }

    public void addPredicated(PointsToAnalysis bb, TypeFlow<?> predicatedFlow) {
        predicatedFlow.setPredicate(this);
        ConcurrentLightHashSet.addElement(this, PREDICATED_FLOWS_UPDATER, predicatedFlow);
        if (this.predicateAlreadyTriggered()) {
            predicatedFlow.enableFlow(bb);
            ConcurrentLightHashSet.removeElement(this, PREDICATED_FLOWS_UPDATER, predicatedFlow);
        }
    }

    public Collection<TypeFlow<?>> getPredicatedFlows() {
        return ConcurrentLightHashSet.getElements(this, PREDICATED_FLOWS_UPDATER);
    }

    public void clearPredicatedFlows() {
        ConcurrentLightHashSet.clear(this, PREDICATED_FLOWS_UPDATER);
    }

    public boolean predicateAlreadyTriggered() {
        return AtomicUtils.isSet(this, PREDICATE_TRIGGERED_UPDATER);
    }

    public final boolean isFlowEnabled() {
        return AtomicUtils.isSet(this, IS_ENABLED_UPDATER);
    }

    private void validateSource() {
        assert (!(this.source instanceof Node)) : "must not reference Graal node from TypeFlow: " + String.valueOf(this.source);
    }

    public TypeFlow() {
        this(null, null, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(TypeState typeState) {
        this(null, null, typeState, -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType) {
        this(source, declaredType, TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType, boolean canBeNull) {
        this(source, declaredType, canBeNull ? TypeState.forNull() : TypeState.forEmpty(), -1, false, null);
    }

    public TypeFlow(T source, AnalysisType declaredType, TypeState state) {
        this(source, declaredType, state, -1, false, null);
    }

    public TypeFlow(TypeFlow<T> original, MethodFlowsGraph graphRef) {
        this(original, graphRef, TypeState.forEmpty());
    }

    public TypeFlow(TypeFlow<T> original, MethodFlowsGraph graphRef, TypeState cloneState) {
        this(original.getSource(), original.getDeclaredType(), cloneState, original.getSlot(), true, graphRef);
        PointsToStats.registerTypeFlowRetainReason(this, original);
        if (original.isFlowEnabled()) {
            this.enableFlow(null);
        }
    }

    public TypeFlow<T> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return this;
    }

    public void initFlow(PointsToAnalysis bb) {
        throw AnalysisError.shouldNotReachHere("Type flow " + this.format(false, true) + " is not overriding initFlow().");
    }

    public boolean needsInitialization() {
        return false;
    }

    public TypeFlow<?> receiver() {
        return null;
    }

    public int id() {
        return this.id;
    }

    public MethodFlowsGraph graphRef() {
        if (this.graphRef != null) {
            return this.graphRef;
        }
        T t = this.source;
        if (t instanceof BytecodePosition) {
            MethodTypeFlow methodFlow;
            BytecodePosition position = (BytecodePosition)t;
            if (!this.isClone && (methodFlow = ((PointsToAnalysisMethod)position.getMethod()).getTypeFlow()).flowsGraphCreated()) {
                return methodFlow.getMethodFlowsGraph();
            }
        }
        return null;
    }

    public AnalysisMethod method() {
        if (this.graphRef != null) {
            return this.graphRef.getMethod();
        }
        if (this.source instanceof BytecodePosition) {
            BytecodePosition position = (BytecodePosition)this.source;
            return (AnalysisMethod)position.getMethod();
        }
        return null;
    }

    public T getSource() {
        return this.source;
    }

    public boolean isClone() {
        return this.isClone;
    }

    public boolean isContextInsensitive() {
        return false;
    }

    public TypeState getOutputState(BigBang bb) {
        if (!this.isFlowEnabled()) {
            return TypeState.forEmpty();
        }
        if (this.isSaturated()) {
            assert (this.declaredType != null) : this;
            return this.declaredType.getTypeFlow((BigBang)bb, (boolean)true).state;
        }
        return this.state;
    }

    public TypeState getState() {
        assert (this.isFlowEnabled()) : "This method should be used only for enabled flows: " + String.valueOf(this);
        return this.state;
    }

    public TypeState getRawState() {
        return this.state;
    }

    public AnalysisType getDeclaredType() {
        return this.declaredType;
    }

    public boolean isAllInstantiated() {
        return this instanceof AllInstantiatedTypeFlow;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isSaturated() {
        return AtomicUtils.isSet(this, SATURATED_UPDATER);
    }

    public boolean canSaturate(PointsToAnalysis bb) {
        return true;
    }

    public boolean setSaturated() {
        assert (this.isFlowEnabled()) : "A flow cannot saturate before it is enabled.";
        return AtomicUtils.atomicMark(this, SATURATED_UPDATER);
    }

    public boolean addState(PointsToAnalysis bb, TypeState add) {
        return this.addState(bb, add, true);
    }

    public boolean addState(PointsToAnalysis bb, TypeState add, boolean postFlow) {
        TypeState after;
        TypeState before;
        PointsToStats.registerTypeFlowUpdate(bb, this, add);
        do {
            if (!(after = this.newState(bb, add, before = this.state)).equals(before)) continue;
            return false;
        } while (!STATE_UPDATER.compareAndSet(this, before, after));
        PointsToStats.registerTypeFlowSuccessfulUpdate(bb, this, add);
        assert (!bb.trackPrimitiveValues() || this.primitiveFlowCheck(after)) : String.valueOf(after) + ", " + String.valueOf(this);
        if (this.isFlowEnabled()) {
            this.propagateState(bb, postFlow, after);
        }
        return true;
    }

    private TypeState newState(PointsToAnalysis bb, TypeState add, TypeState before) {
        TypeState filteredAdd = this.processInputState(bb, add);
        return TypeState.forUnion(bb, before, filteredAdd);
    }

    protected void propagateState(PointsToAnalysis bb, boolean postFlow, TypeState newState) {
        assert (this.isFlowEnabled()) : "A flow cannot propagate state before it is enabled: " + String.valueOf(this);
        assert (newState.isNotEmpty()) : "Empty state should not trigger propagation: " + String.valueOf(this);
        this.enablePredicated(bb);
        if (this.checkSaturated(bb, newState)) {
            this.onSaturated(bb);
        } else if (postFlow) {
            bb.postFlow(this);
        }
    }

    protected void enablePredicated(PointsToAnalysis bb) {
        if (AtomicUtils.atomicMark(this, PREDICATE_TRIGGERED_UPDATER)) {
            ConcurrentLightHashSet.forEach(this, PREDICATED_FLOWS_UPDATER, predicatedFlow -> bb.postTask(() -> predicatedFlow.enableFlow(bb)));
            ConcurrentLightHashSet.clear(this, PREDICATED_FLOWS_UPDATER);
        }
    }

    public boolean addUse(PointsToAnalysis bb, TypeFlow<?> use) {
        return this.addUse(bb, use, true);
    }

    private boolean checkDefUseCompatibility(TypeFlow<?> use) {
        if (this.declaredType == null || use.declaredType == null) {
            return true;
        }
        if (this.isPrimitiveFlow != use.isPrimitiveFlow) {
            if (this instanceof OffsetStoreTypeFlow.UnsafeStoreTypeFlow) {
                return true;
            }
            if (!this.isPrimitiveFlow && (use instanceof BooleanNullCheckTypeFlow || use instanceof BooleanInstanceOfCheckTypeFlow)) {
                return true;
            }
            return use instanceof FormalReturnTypeFlow && use.getDeclaredType().getJavaKind() == JavaKind.Void;
        }
        return true;
    }

    public boolean addUse(PointsToAnalysis bb, TypeFlow<?> use, boolean propagateTypeState) {
        assert (!bb.trackPrimitiveValues() || this.checkDefUseCompatibility(use)) : "Incompatible flows: " + String.valueOf(this) + " connected with " + String.valueOf(use);
        if (this.isSaturated() && propagateTypeState) {
            this.registerInput(bb, use);
            this.notifyUseOfSaturation(bb, use);
            return false;
        }
        if (this.doAddUse(bb, use)) {
            if (propagateTypeState) {
                if (this.isSaturated()) {
                    this.notifyUseOfSaturation(bb, use);
                    this.removeUse(use);
                    return false;
                }
                if (this.isFlowEnabled()) {
                    use.addState(bb, this.getState());
                }
            }
            return true;
        }
        return false;
    }

    protected void notifyUseOfSaturation(PointsToAnalysis bb, TypeFlow<?> use) {
        use.markInputSaturated(bb, this);
    }

    protected boolean doAddUse(PointsToAnalysis bb, TypeFlow<?> use) {
        if (use.equals(this)) {
            return false;
        }
        if (!use.isValid()) {
            return false;
        }
        this.registerInput(bb, use);
        if (use.isSaturated()) {
            return false;
        }
        return ConcurrentLightHashSet.addElement(this, USE_UPDATER, use);
    }

    private void registerInput(PointsToAnalysis bb, TypeFlow<?> use) {
        if (bb.trackTypeFlowInputs()) {
            use.addInput(this);
        }
    }

    public boolean removeUse(TypeFlow<?> use) {
        return ConcurrentLightHashSet.removeElement(this, USE_UPDATER, use);
    }

    public void clearUses() {
        ConcurrentLightHashSet.clear(this, USE_UPDATER);
    }

    public Collection<TypeFlow<?>> getUses() {
        return ConcurrentLightHashSet.getElements(this, USE_UPDATER);
    }

    public void addObserver(PointsToAnalysis bb, TypeFlow<?> observer) {
        this.addObserver(bb, observer, true);
    }

    public boolean addObserver(PointsToAnalysis bb, TypeFlow<?> observer, boolean triggerUpdate) {
        if (this.isSaturated() && triggerUpdate) {
            this.registerObservee(bb, observer);
            this.notifyObserverOfSaturation(bb, observer);
            return false;
        }
        if (this.doAddObserver(bb, observer)) {
            if (triggerUpdate) {
                if (this.isSaturated()) {
                    this.notifyObserverOfSaturation(bb, observer);
                    this.removeObserver(observer);
                    return false;
                }
                if (this.isFlowEnabled() && !this.state.isEmpty()) {
                    bb.postTask(ignore -> observer.onObservedUpdate(bb));
                }
            }
            return true;
        }
        return false;
    }

    protected void notifyObserverOfSaturation(PointsToAnalysis bb, TypeFlow<?> observer) {
        observer.markObservedSaturated(bb, this);
    }

    private boolean doAddObserver(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (observer.equals(this)) {
            return false;
        }
        if (!observer.isValid()) {
            return false;
        }
        this.registerObservee(bb, observer);
        return ConcurrentLightHashSet.addElement(this, OBSERVERS_UPDATER, observer);
    }

    private void registerObservee(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (bb.trackTypeFlowInputs()) {
            observer.addObservee(this);
        }
    }

    public boolean removeObserver(TypeFlow<?> observer) {
        return ConcurrentLightHashSet.removeElement(this, OBSERVERS_UPDATER, observer);
    }

    public void clearObservers() {
        ConcurrentLightHashSet.clear(this, OBSERVERS_UPDATER);
    }

    public Collection<TypeFlow<?>> getObservers() {
        return ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER);
    }

    public void addObservee(TypeFlow<?> observee) {
        ConcurrentLightHashSet.addElement(this, OBSERVEES_UPDATER, observee);
    }

    public Collection<TypeFlow<?>> getObservees() {
        return ConcurrentLightHashSet.getElements(this, OBSERVEES_UPDATER);
    }

    public void clearObservees() {
        ConcurrentLightHashSet.clear(this, OBSERVEES_UPDATER);
    }

    public void addInput(TypeFlow<?> input) {
        ConcurrentLightHashSet.addElement(this, INPUTS_UPDATER, input);
    }

    public Collection<TypeFlow<?>> getInputs() {
        return ConcurrentLightHashSet.getElements(this, INPUTS_UPDATER);
    }

    public void clearInputs() {
        ConcurrentLightHashSet.clear(this, INPUTS_UPDATER);
    }

    protected TypeState processInputState(PointsToAnalysis bb, TypeState newState) {
        return newState;
    }

    public TypeState declaredTypeFilter(PointsToAnalysis bb, TypeState newState) {
        return this.declaredTypeFilter(bb, newState, true);
    }

    public TypeState declaredTypeFilter(PointsToAnalysis bb, TypeState newState, boolean onlyWithRelaxedTypeFlowConstraints) {
        if (onlyWithRelaxedTypeFlowConstraints && !bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return newState;
        }
        if (this.declaredType == null) {
            return newState;
        }
        if (this.declaredType.equals(bb.getObjectType())) {
            return newState;
        }
        if (this.isPrimitiveFlow) {
            assert (this.primitiveFlowCheck(newState)) : String.valueOf(newState) + ", " + String.valueOf(this);
            return newState;
        }
        return TypeState.forIntersection(bb, newState, this.declaredType.getAssignableTypes(true));
    }

    private boolean primitiveFlowCheck(TypeState newState) {
        return !this.isPrimitiveFlow || newState.isPrimitive() || newState.isEmpty();
    }

    public static AnalysisType filterUncheckedInterface(AnalysisType type) {
        AnalysisType elementalType;
        if (type != null && (elementalType = type.getElementalType()).isInterface() && !elementalType.isWordType()) {
            return type.getUniverse().objectType().getArrayClass(type.getArrayDimension());
        }
        return type;
    }

    public void update(PointsToAnalysis bb) {
        TypeState curState = this.getState();
        for (TypeFlow<?> use : this.getUses()) {
            if (!use.isValid() || use.isSaturated()) {
                this.removeUse(use);
                continue;
            }
            use.addState(bb, curState);
        }
        for (TypeFlow<?> observer : this.getObservers()) {
            if (observer.isValid()) {
                observer.onObservedUpdate(bb);
                continue;
            }
            this.removeObserver(observer);
        }
    }

    public void onObservedUpdate(PointsToAnalysis bb) {
    }

    boolean checkSaturated(PointsToAnalysis bb, TypeState typeState) {
        if (!bb.analysisPolicy().removeSaturatedTypeFlows()) {
            return false;
        }
        if (!this.canSaturate(bb)) {
            return false;
        }
        if (typeState.isPrimitive()) {
            return ((PrimitiveTypeState)typeState).isAnyPrimitive();
        }
        return typeState.typesCount() > bb.analysisPolicy().typeFlowSaturationCutoff();
    }

    protected void onSaturated(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().removeSaturatedTypeFlows()) : "The type flow saturation optimization is disabled.";
        assert (this.canSaturate(bb)) : "This type flow cannot saturate.";
        assert (this.isFlowEnabled()) : "A flow cannot saturate before it is enabled.";
        assert (bb.analysisPolicy().aliasArrayTypeFlows()) : "Array type flows must be aliased.";
        if (!this.setSaturated()) {
            return;
        }
        this.onSaturated();
        this.enablePredicated(bb);
        this.notifySaturated(bb);
    }

    protected void onSaturated() {
    }

    private void notifySaturated(PointsToAnalysis bb) {
        for (TypeFlow<?> use : this.getUses()) {
            this.notifyUseOfSaturation(bb, use);
        }
        this.clearUses();
        for (TypeFlow<?> observer : this.getObservers()) {
            this.notifyObserverOfSaturation(bb, observer);
        }
        this.clearObservers();
    }

    protected void swapOut(PointsToAnalysis bb, TypeFlow<?> newFlow) {
        assert (this.isSaturated()) : "This operation should only be called on saturated flows:" + String.valueOf(this);
        for (TypeFlow<?> use : this.getUses()) {
            newFlow.addUse(bb, use);
        }
        this.clearUses();
        for (TypeFlow<?> observer : this.getObservers()) {
            observer.replacedObservedWith(bb, newFlow);
        }
        this.clearObservers();
        AtomicUtils.atomicMark(this, PREDICATE_TRIGGERED_UPDATER);
        for (TypeFlow<?> predicatedFlow : this.getPredicatedFlows()) {
            newFlow.addPredicated(bb, predicatedFlow);
        }
        this.clearPredicatedFlows();
    }

    protected void swapAtUse(PointsToAnalysis bb, TypeFlow<?> newFlow, TypeFlow<?> use) {
        this.removeUse(use);
        newFlow.addUse(bb, use);
    }

    protected void swapAtObserver(PointsToAnalysis bb, TypeFlow<?> newFlow, TypeFlow<?> observer) {
        this.removeObserver(observer);
        observer.replacedObservedWith(bb, newFlow);
    }

    private void markInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        this.inputSaturated = 1;
        if (!this.isFlowEnabled()) {
            return;
        }
        if (INPUT_SATURATED_UPDATER.compareAndSet(this, 1, 2)) {
            this.onInputSaturated(bb, input);
        }
    }

    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        assert (bb.analysisPolicy().removeSaturatedTypeFlows()) : "The type flow saturation optimization is disabled.";
        if (!this.canSaturate(bb)) {
            return;
        }
        this.onSaturated(bb);
    }

    private void markObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        this.observedSaturated = 1;
        if (!this.isFlowEnabled()) {
            return;
        }
        if (OBSERVED_SATURATED_UPDATER.compareAndSet(this, 1, 2)) {
            this.onObservedSaturated(bb, observed);
        }
    }

    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
    }

    public void replaceObservedWith(PointsToAnalysis bb, AnalysisType newObservedType) {
        this.replacedObservedWith(bb, newObservedType.getTypeFlow(bb, false));
    }

    public void replacedObservedWith(PointsToAnalysis bb, TypeFlow<?> newObservedFlow) {
        this.setObserved(newObservedFlow);
        newObservedFlow.addObserver(bb, this);
    }

    protected void setObserved(TypeFlow<?> newObservedFlow) {
    }

    void updateSource(T newSource) {
        this.source = newSource;
        this.validateSource();
    }

    public boolean validateFixedPointState(BigBang bb) {
        if (!this.isFlowEnabled()) {
            assert (!this.isSaturated()) : "Flows cannot be saturated before they are enabled " + String.valueOf(this);
            assert (!this.predicateAlreadyTriggered()) : "This flow is disabled, predicate edge should not have been triggered " + String.valueOf(this);
            return true;
        }
        if (!this.isSaturated() && this.state.isEmpty()) {
            assert (!this.predicateAlreadyTriggered()) : "Predicate edge should only be triggered after the state becomes non-empty or the flow saturates " + String.valueOf(this);
            return true;
        }
        if (this instanceof InvokeTypeFlow) {
            assert (this.getPredicatedFlows().isEmpty()) : "Invoke flows should have no predicated flows " + String.valueOf(this);
            assert (!this.predicateAlreadyTriggered()) : "Invoke flows should not use their predicate edge at all" + String.valueOf(this);
        } else {
            assert (this.predicateAlreadyTriggered()) : "This flow is either saturated or has non-empty state, therefore the predicate edge should have been already triggered " + String.valueOf(this);
            for (TypeFlow<?> predicated : this.getPredicatedFlows()) {
                assert (predicated.isFlowEnabled()) : "Predicate edge was triggered, therefore " + String.valueOf(predicated) + " should have been enabled from " + String.valueOf(this);
            }
        }
        PointsToAnalysis pta = (PointsToAnalysis)bb;
        if (this.isSaturated()) {
            assert (this.getUses().isEmpty()) : "Uses of saturated flows should have been removed by now " + String.valueOf(this) + " " + String.valueOf(this.getUses());
            assert (this.getObservers().isEmpty()) : "Observers of saturated flows should have been removed by now " + String.valueOf(this) + " " + String.valueOf(this.getObservers());
        } else {
            for (TypeFlow<?> use : this.getUses()) {
                if (!use.isFlowEnabled() || use.isSaturated() || use instanceof FormalReceiverTypeFlow) continue;
                TypeState nextState = use.newState(pta, this.state, use.state);
                assert (nextState.equals(use.state) || !use.isFlowEnabled() && INPUT_SATURATED_UPDATER.get(use) == 1) : "State from " + String.valueOf(this) + " to " + String.valueOf(use) + " was not propagated correctly: " + String.valueOf(use.state) + " " + String.valueOf(this.state) + " => " + String.valueOf(nextState);
            }
        }
        return true;
    }

    public String formatSource() {
        if (this.source instanceof BytecodePosition) {
            BytecodePosition position = (BytecodePosition)this.source;
            return position.getMethod().asStackTraceElement(position.getBCI()).toString();
        }
        if (this.source == null && this.method() != null) {
            return this.method().asStackTraceElement(-1).toString();
        }
        return "<unknown-position>";
    }

    public String format(boolean withState, boolean withSource) {
        return ClassUtil.getUnqualifiedName(this.getClass()) + (String)(withSource ? " at " + this.formatSource() : "") + (String)(withState ? " with state <" + this.getStateDescription() + ">" : "");
    }

    protected final String getStateDescription() {
        if (!this.isFlowEnabled()) {
            return "DISABLED: " + String.valueOf(this.state);
        }
        if (this.isSaturated()) {
            return "SATURATED: " + String.valueOf(this.state);
        }
        return this.state.toString();
    }

    public String toString() {
        return this.format(true, true);
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }
}

