/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.ImageLayerLoader;
import com.oracle.graal.pointsto.api.ImageLayerWriter;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisMethod
extends AnalysisElement
implements WrappedJavaMethod,
GraphProvider,
OriginalMethodProvider,
MultiMethod {
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isVirtualRootMethodUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isVirtualRootMethod");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isDirectRootMethodUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isDirectRootMethod");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isInvokedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isInvoked");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isImplementationInvokedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isImplementationInvoked");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> implementationInvokedNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "implementationInvokedNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isIntrinsicMethodUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isIntrinsicMethod");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> isInlinedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "isInlined");
    static final AtomicReferenceFieldUpdater<AnalysisMethod, Object> allImplementationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Object.class, "allImplementations");
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Boolean> reachableInCurrentLayerUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Boolean.class, "reachableInCurrentLayer");
    public static final AnalysisMethod[] EMPTY_ARRAY = new AnalysisMethod[0];
    public final ResolvedJavaMethod wrapped;
    private AnalysisMethod indirectCallTarget = null;
    public boolean invalidIndirectCallTarget = false;
    private final int id;
    private final boolean isInBaseLayer;
    private final boolean analyzedInPriorLayer;
    private final boolean hasNeverInlineDirective;
    private final ExceptionHandler[] exceptionHandlers;
    private final LocalVariableTable localVariableTable;
    private final String name;
    private final String qualifiedName;
    private final int modifiers;
    protected final AnalysisType declaringClass;
    protected final ResolvedSignature<AnalysisType> signature;
    private final int parsingContextMaxDepth;
    private final MultiMethod.MultiMethodKey multiMethodKey;
    private volatile Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap;
    private static final AtomicReferenceFieldUpdater<AnalysisMethod, Map> MULTIMETHOD_MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisMethod.class, Map.class, "multiMethodMap");
    private volatile Object isVirtualRootMethod;
    private volatile Object isDirectRootMethod;
    private Object nativeEntryPointData;
    private volatile Object isInvoked;
    private volatile Object isImplementationInvoked;
    private volatile Object implementationInvokedNotifications;
    private volatile Object isIntrinsicMethod;
    private volatile Object isInlined;
    private volatile Boolean reachableInCurrentLayer;
    private final boolean enableReachableInCurrentLayer;
    private final AtomicReference<GraphCacheEntry> parsedGraphCacheState = new AtomicReference<GraphCacheEntry>(GraphCacheEntry.UNPARSED);
    private final AtomicBoolean trackedGraphPersisted = new AtomicBoolean(false);
    private EncodedGraph analyzedGraph;
    private volatile Object allImplementations;
    private boolean hasOpaqueReturn;
    private static final GraphSupplier CREATE_FIRST_STAGE = (bb, method, curState) -> new GraphCacheEntry(AnalysisParsedGraph.parseBytecode(bb, method), GraphCacheEntry.GRAPH_CACHE_UNPARSED);
    private static final GraphSupplier GET_FROM_BASE_LAYER = (bb, method, curState) -> {
        AnalysisParsedGraph graph = method.getUniverse().getImageLayerLoader().getAnalysisParsedGraph(method);
        return new GraphCacheEntry(graph, graph);
    };
    private static final GraphSupplier CREATE_FINAL_STAGE = (bb, method, curState) -> {
        AnalysisParsedGraph stage1Graph = null;
        AnalysisParsedGraph.Stage previous = AnalysisParsedGraph.Stage.firstStage();
        if (curState.isStageParsed(previous)) {
            stage1Graph = (AnalysisParsedGraph)curState.get(previous);
        }
        AnalysisParsedGraph stage2Graph = AnalysisParsedGraph.createFinalStage(bb, method, stage1Graph);
        if (stage1Graph != null) {
            return new GraphCacheEntry(stage1Graph, stage2Graph);
        }
        return new GraphCacheEntry(stage2Graph, stage2Graph);
    };
    private static final GraphSupplier REPARSE_FINAL_STAGE = (bb, method, curState) -> {
        AnalysisParsedGraph stage2Graph = AnalysisParsedGraph.createFinalStage(bb, method, null);
        return new GraphCacheEntry(stage2Graph, stage2Graph);
    };

    protected AnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped, MultiMethod.MultiMethodKey multiMethodKey, Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap) {
        super(universe.hostVM.enableTrackAcrossLayers());
        ResolvedSignature<Object> resolvedSignature;
        this.wrapped = wrapped;
        this.declaringClass = universe.lookup((JavaType)wrapped.getDeclaringClass());
        jdk.vm.ci.meta.Signature wrappedSignature = wrapped.getSignature();
        this.signature = wrappedSignature instanceof ResolvedSignature ? ((resolvedSignature = (ResolvedSignature<Object>)wrappedSignature).getReturnType() instanceof AnalysisType ? resolvedSignature : this.getUniverse().lookup(wrappedSignature, wrapped.getDeclaringClass())) : this.getUniverse().lookup(wrappedSignature, wrapped.getDeclaringClass());
        this.hasNeverInlineDirective = universe.hostVM().hasNeverInlineDirective(wrapped);
        this.name = AnalysisMethod.createName(wrapped, multiMethodKey);
        this.qualifiedName = this.format("%H.%n(%P)");
        this.modifiers = wrapped.getModifiers();
        if (universe.hostVM().useBaseLayer() && this.declaringClass.isInBaseLayer()) {
            int mid = universe.getImageLayerLoader().lookupHostedMethodInBaseLayer(this);
            if (mid != -1) {
                this.id = mid;
                this.isInBaseLayer = true;
            } else {
                this.id = universe.computeNextMethodId();
                this.isInBaseLayer = false;
            }
        } else {
            this.id = universe.computeNextMethodId();
            this.isInBaseLayer = false;
        }
        this.analyzedInPriorLayer = this.isInBaseLayer && universe.hostVM().analyzedInPriorLayer(this);
        ExceptionHandler[] original = wrapped.getExceptionHandlers();
        this.exceptionHandlers = new ExceptionHandler[original.length];
        for (int i = 0; i < original.length; ++i) {
            ExceptionHandler h = original[i];
            JavaType catchType = AnalysisMethod.getCatchType(universe, wrapped, h);
            this.exceptionHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        LocalVariableTable analysisLocalVariableTable = null;
        if (wrapped.getLocalVariableTable() != null) {
            try {
                Local[] origLocals = wrapped.getLocalVariableTable().getLocals();
                Local[] newLocals = new Local[origLocals.length];
                ResolvedJavaType accessingClass = this.declaringClass.getWrapped();
                for (int i = 0; i < newLocals.length; ++i) {
                    Local origLocal = origLocals[i];
                    ResolvedJavaType origLocalType = origLocal.getType() instanceof ResolvedJavaType ? (ResolvedJavaType)origLocal.getType() : origLocal.getType().resolve(accessingClass);
                    AnalysisType type = universe.lookup((JavaType)origLocalType);
                    newLocals[i] = new Local(origLocal.getName(), (JavaType)type, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
                }
                analysisLocalVariableTable = new LocalVariableTable(newLocals);
            }
            catch (UnsupportedFeatureException | LinkageError | BytecodeParser.BytecodeParserError throwable) {
                // empty catch block
            }
        }
        this.localVariableTable = analysisLocalVariableTable;
        this.multiMethodKey = multiMethodKey;
        this.multiMethodMap = multiMethodMap;
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(this.declaringClass.universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
        this.parsingContextMaxDepth = (Integer)PointstoOptions.ParsingContextMaxDepth.getValue(this.declaringClass.universe.hostVM.options());
        this.enableReachableInCurrentLayer = universe.hostVM.enableReachableInCurrentLayer();
    }

    protected AnalysisMethod(AnalysisMethod original, MultiMethod.MultiMethodKey multiMethodKey) {
        super(original.enableTrackAcrossLayers);
        this.wrapped = original.wrapped;
        this.id = original.id;
        this.isInBaseLayer = original.isInBaseLayer;
        this.analyzedInPriorLayer = original.analyzedInPriorLayer;
        this.declaringClass = original.declaringClass;
        this.signature = original.signature;
        this.hasNeverInlineDirective = original.hasNeverInlineDirective;
        this.exceptionHandlers = original.exceptionHandlers;
        this.localVariableTable = original.localVariableTable;
        this.parsingContextMaxDepth = original.parsingContextMaxDepth;
        this.name = AnalysisMethod.createName(this.wrapped, multiMethodKey);
        this.qualifiedName = this.format("%H.%n(%P)");
        this.modifiers = original.modifiers;
        this.multiMethodKey = multiMethodKey;
        assert (original.multiMethodMap != null);
        this.multiMethodMap = original.multiMethodMap;
        this.hasOpaqueReturn = original.hasOpaqueReturn;
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(this.declaringClass.universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
        this.enableReachableInCurrentLayer = original.enableReachableInCurrentLayer;
    }

    private static String createName(ResolvedJavaMethod wrapped, MultiMethod.MultiMethodKey multiMethodKey) {
        Object aName = wrapped.getName();
        if (multiMethodKey != ORIGINAL_METHOD) {
            aName = (String)aName + "%%" + String.valueOf(multiMethodKey);
        }
        return aName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private static JavaType getCatchType(AnalysisUniverse universe, ResolvedJavaMethod wrapped, ExceptionHandler handler) {
        ResolvedJavaType resolvedCatchType;
        JavaType catchType = handler.getCatchType();
        if (catchType == null) {
            return null;
        }
        try {
            resolvedCatchType = catchType.resolve(wrapped.getDeclaringClass());
        }
        catch (LinkageError e) {
            return catchType;
        }
        return universe.lookup((JavaType)resolvedCatchType);
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    private static boolean matchingSignature(AnalysisMethod o1, AnalysisMethod o2) {
        if (o1.equals(o2)) {
            return true;
        }
        if (!o1.getName().equals(o2.getName())) {
            return false;
        }
        return o1.getSignature().equals(o2.getSignature());
    }

    private AnalysisMethod setIndirectCallTarget(AnalysisMethod method, boolean foundMatch) {
        this.indirectCallTarget = method;
        this.invalidIndirectCallTarget = !foundMatch;
        return this.indirectCallTarget;
    }

    public AnalysisMethod getIndirectCallTarget() {
        if (this.indirectCallTarget != null) {
            return this.indirectCallTarget;
        }
        if (this.isStatic() || this.isConstructor()) {
            return this.setIndirectCallTarget(this, true);
        }
        Set<AnalysisMethod> dispatchTableMethods = this.declaringClass.getOrCalculateOpenTypeWorldDispatchTableMethods();
        if (dispatchTableMethods.contains(this)) {
            return this.setIndirectCallTarget(this, true);
        }
        for (AnalysisType interfaceType : this.declaringClass.getAllInterfaces()) {
            if (interfaceType.equals(this.declaringClass)) continue;
            dispatchTableMethods = interfaceType.getOrCalculateOpenTypeWorldDispatchTableMethods();
            for (AnalysisMethod candidate : dispatchTableMethods) {
                if (!AnalysisMethod.matchingSignature(candidate, this)) continue;
                return this.setIndirectCallTarget(candidate, true);
            }
        }
        return this.setIndirectCallTarget(this, false);
    }

    public boolean validateFixedPointState(BigBang bb) {
        return true;
    }

    public void cleanupAfterAnalysis() {
        GraphCacheEntry graphCacheEntry = this.parsedGraphCacheState.get();
        if (graphCacheEntry != GraphCacheEntry.CLEARED) {
            this.parsedGraphCacheState.set(GraphCacheEntry.CLEARED);
        }
    }

    public abstract void startTrackInvocations();

    public abstract Iterable<? extends InvokeInfo> getInvokes();

    public abstract Object getParsingReason();

    public final StackTraceElement[] getParsingContext() {
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Object curr = this.getParsingReason();
        while (curr != null) {
            if (!(curr instanceof BytecodePosition)) {
                AnalysisError.guarantee(curr instanceof String, "Parsing reason should be a BytecodePosition or String: %s", curr);
                trace.add(ReportUtils.rootMethodSentinel((String)curr));
                break;
            }
            if (trace.size() > this.parsingContextMaxDepth) {
                trace.add(ReportUtils.truncatedStackTraceSentinel(this));
                break;
            }
            BytecodePosition position = (BytecodePosition)curr;
            AnalysisMethod caller = (AnalysisMethod)position.getMethod();
            trace.add(caller.asStackTraceElement(position.getBCI()));
            curr = caller.getParsingReason();
        }
        return trace.toArray(new StackTraceElement[0]);
    }

    public int getId() {
        return this.id;
    }

    public boolean isInBaseLayer() {
        return this.isInBaseLayer;
    }

    public boolean analyzedInPriorLayer() {
        return this.analyzedInPriorLayer;
    }

    public boolean reachableInCurrentLayer() {
        return this.enableReachableInCurrentLayer && this.reachableInCurrentLayer != null && this.reachableInCurrentLayer != false;
    }

    public void setReachableInCurrentLayer() {
        if (this.enableReachableInCurrentLayer && !this.reachableInCurrentLayer()) {
            AtomicUtils.atomicSetAndRun(this, true, reachableInCurrentLayerUpdater, () -> {
                ImageLayerLoader imageLayerLoader = this.getUniverse().getImageLayerLoader();
                if (imageLayerLoader != null) {
                    imageLayerLoader.loadPriorStrengthenedGraphAnalysisElements(this);
                }
                ConcurrentLightHashSet.forEach(this, allImplementationsUpdater, AnalysisMethod::setReachableInCurrentLayer);
            });
        }
    }

    public void registerAsIntrinsicMethod(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a method as intrinsic needs to provide a valid reason, found: " + String.valueOf(reason);
        AtomicUtils.atomicSetAndRun(this, reason, isIntrinsicMethodUpdater, () -> this.onImplementationInvoked(reason));
    }

    public void registerAsNativeEntryPoint(Object newEntryPointData) {
        assert (newEntryPointData != null);
        assert (this.isDirectRootMethod()) : "All native entrypoints must be direct root methods: " + String.valueOf(this);
        if (this.nativeEntryPointData != null && !this.nativeEntryPointData.equals(newEntryPointData)) {
            throw new UnsupportedFeatureException("Method is registered as entry point with conflicting entry point data: " + String.valueOf(this.nativeEntryPointData) + ", " + String.valueOf(newEntryPointData));
        }
        this.nativeEntryPointData = newEntryPointData;
        this.startTrackInvocations();
    }

    public boolean registerAsInvoked(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a method as invoked needs to provide a valid reason, found: " + String.valueOf(reason);
        this.registerAsTrackedAcrossLayers(reason);
        return AtomicUtils.atomicSet(this, reason, isInvokedUpdater);
    }

    public boolean registerAsImplementationInvoked(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a method as implementation invoked needs to provide a valid reason, found: " + String.valueOf(reason);
        assert (!Modifier.isAbstract(this.getModifiers())) : this;
        this.getDeclaringClass().registerAsReachable("declared method " + this.qualifiedName + " is registered as implementation invoked");
        return AtomicUtils.atomicSetAndRun(this, reason, isImplementationInvokedUpdater, () -> this.onImplementationInvoked(reason));
    }

    public void registerAsInlined(Object reason) {
        assert (reason instanceof NodeSourcePosition || reason instanceof ResolvedJavaMethod) : "Registering a method as inlined needs to provide the inline location as reason, found: " + String.valueOf(reason);
        AtomicUtils.atomicSetAndRun(this, reason, isInlinedUpdater, () -> this.onReachable(reason));
    }

    public void registerImplementationInvokedCallback(Consumer<Feature.DuringAnalysisAccess> callback) {
        if (this.isImplementationInvoked()) {
            AnalysisMethod.execute(this.getUniverse(), () -> callback.accept(this.declaringClass.getUniverse().getConcurrentAnalysisAccess()));
        } else {
            AnalysisElement.ElementNotification notification = new AnalysisElement.ElementNotification(callback);
            ConcurrentLightHashSet.addElement(this, implementationInvokedNotificationsUpdater, notification);
            if (this.isImplementationInvoked()) {
                this.notifyImplementationInvokedCallback(notification);
            }
        }
    }

    private void notifyImplementationInvokedCallback(AnalysisElement.ElementNotification notification) {
        notification.notifyCallback(this.declaringClass.getUniverse(), this);
        ConcurrentLightHashSet.removeElement(this, implementationInvokedNotificationsUpdater, notification);
    }

    protected void notifyImplementationInvokedCallbacks() {
        ConcurrentLightHashSet.forEach(this, implementationInvokedNotificationsUpdater, c -> c.notifyCallback(this.declaringClass.getUniverse(), this));
        ConcurrentLightHashSet.removeElementIf(this, implementationInvokedNotificationsUpdater, AnalysisElement.ElementNotification::isNotified);
    }

    private void persistTrackedGraph(AnalysisParsedGraph graph) {
        if (this.isTrackedAcrossLayers() && this.trackedGraphPersisted.compareAndSet(false, true)) {
            ImageLayerWriter imageLayerWriter = this.getUniverse().getImageLayerWriter();
            imageLayerWriter.persistAnalysisParsedGraph(this, graph);
        }
    }

    public Set<AnalysisMethod> getCallers() {
        return this.getInvokeLocations().stream().map(location -> (AnalysisMethod)location.getMethod()).collect(Collectors.toSet());
    }

    public abstract List<BytecodePosition> getInvokeLocations();

    public boolean isNativeEntryPoint() {
        return this.nativeEntryPointData != null;
    }

    public Object getNativeEntryPointData() {
        return this.nativeEntryPointData;
    }

    public boolean isIntrinsicMethod() {
        return AtomicUtils.isSet(this, isIntrinsicMethodUpdater);
    }

    public Object getIntrinsicMethodReason() {
        return this.isIntrinsicMethod;
    }

    public boolean registerAsVirtualRootMethod(Object reason) {
        this.getDeclaringClass().registerAsReachable("declared method " + this.qualifiedName + " is registered as virtual root");
        return AtomicUtils.atomicSet(this, reason, isVirtualRootMethodUpdater);
    }

    public boolean registerAsDirectRootMethod(Object reason) {
        this.getDeclaringClass().registerAsReachable("declared method " + this.qualifiedName + " is registered as direct root");
        return AtomicUtils.atomicSet(this, reason, isDirectRootMethodUpdater);
    }

    public boolean isVirtualRootMethod() {
        return AtomicUtils.isSet(this, isVirtualRootMethodUpdater);
    }

    public boolean isDirectRootMethod() {
        return AtomicUtils.isSet(this, isDirectRootMethodUpdater);
    }

    public boolean isSimplyInvoked() {
        return AtomicUtils.isSet(this, isInvokedUpdater);
    }

    public boolean isSimplyImplementationInvoked() {
        return AtomicUtils.isSet(this, isImplementationInvokedUpdater);
    }

    public boolean isInvoked() {
        return this.isIntrinsicMethod() || this.isVirtualRootMethod() || this.isDirectRootMethod() || AtomicUtils.isSet(this, isInvokedUpdater);
    }

    public Object getInvokedReason() {
        return this.isInvoked;
    }

    public boolean isImplementationInvoked() {
        return !Modifier.isAbstract(this.getModifiers()) && (this.isIntrinsicMethod() || AtomicUtils.isSet(this, isImplementationInvokedUpdater));
    }

    public Object getImplementationInvokedReason() {
        return this.isImplementationInvoked;
    }

    public boolean isInlined() {
        return AtomicUtils.isSet(this, isInlinedUpdater);
    }

    protected Object getInlinedReason() {
        return this.isInlined;
    }

    @Override
    public boolean isReachable() {
        return this.isImplementationInvoked() || this.isInlined();
    }

    @Override
    public boolean isTriggered() {
        if (this.isReachable()) {
            return true;
        }
        return this.isClassInitializer() && this.getDeclaringClass().isInitialized();
    }

    public void onImplementationInvoked(Object reason) {
        this.onReachable(reason);
        this.notifyImplementationInvokedCallbacks();
    }

    @Override
    public void onReachable(Object reason) {
        this.registerAsTrackedAcrossLayers(reason);
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
    }

    @Override
    protected void onTrackedAcrossLayers(Object reason) {
        AnalysisError.guarantee(!this.getUniverse().sealed(), "Method %s was marked as tracked after the universe was sealed", this);
        this.getUniverse().getImageLayerWriter().onTrackedAcrossLayer(this, reason);
        this.declaringClass.registerAsTrackedAcrossLayers(reason);
        for (AnalysisType parameter : this.toParameterList()) {
            parameter.registerAsTrackedAcrossLayers(reason);
        }
        this.signature.getReturnType().registerAsTrackedAcrossLayers(reason);
        Object object = this.getParsedGraphCacheStateObject();
        if (object instanceof AnalysisParsedGraph) {
            AnalysisParsedGraph analysisParsedGraph = (AnalysisParsedGraph)object;
            this.persistTrackedGraph(analysisParsedGraph);
        }
    }

    public void registerOverrideReachabilityNotification(AnalysisElement.MethodOverrideReachableNotification notification) {
        this.getUniverse().registerOverrideReachabilityNotification(this, notification);
    }

    @Override
    public ResolvedJavaMethod getWrapped() {
        return this.wrapped;
    }

    public String getName() {
        return this.name;
    }

    public ResolvedSignature<AnalysisType> getSignature() {
        return this.signature;
    }

    public JavaType[] toParameterTypes() {
        throw JVMCIError.shouldNotReachHere((String)"ResolvedJavaMethod.toParameterTypes returns the wrong result for constructors. Use toParameterList instead.");
    }

    public List<AnalysisType> toParameterList() {
        return this.getSignature().toParameterList(this.isStatic() ? null : this.getDeclaringClass());
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ResolvedJavaMethod resolvedJavaMethod = this.wrapped;
        if (resolvedJavaMethod instanceof GraphProvider) {
            GraphProvider graphProvider = (GraphProvider)resolvedJavaMethod;
            return graphProvider.buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    @Override
    public boolean allowRuntimeCompilation() {
        ResolvedJavaMethod resolvedJavaMethod = this.wrapped;
        if (resolvedJavaMethod instanceof GraphProvider) {
            GraphProvider graphProvider = (GraphProvider)resolvedJavaMethod;
            return graphProvider.allowRuntimeCompilation();
        }
        return true;
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.wrapped.isVarArgs();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isDeclared() {
        return this.wrapped.isDeclared();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        boolean result = this.wrapped.canBeStaticallyBound();
        assert (!this.isStatic() || result) : "static methods must always be statically bindable: " + this.format("%H.%n");
        return result;
    }

    public Set<AnalysisMethod> collectMethodImplementations(boolean includeInlinedMethods) {
        boolean includeOurselfs = (this.isStatic() || this.getDeclaringClass().isAnySubtypeInstantiated()) && (includeInlinedMethods ? this.isReachable() : this.isImplementationInvoked());
        int allImplementationsSize = ConcurrentLightHashSet.size(this, allImplementationsUpdater);
        if (allImplementationsSize == 0) {
            return includeOurselfs ? Set.of(this) : Set.of();
        }
        HashSet<AnalysisMethod> result = new HashSet<AnalysisMethod>(allImplementationsSize + 1);
        if (includeOurselfs) {
            result.add(this);
        }
        ConcurrentLightHashSet.forEach(this, allImplementationsUpdater, override -> {
            if (override.getDeclaringClass().isAnySubtypeInstantiated() && (includeInlinedMethods ? override.isReachable() : override.isImplementationInvoked())) {
                result.add((AnalysisMethod)override);
            }
        });
        return result;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return null;
    }

    public ConstantPool getConstantPool() {
        return this.getUniverse().lookup(this.wrapped.getConstantPool(), this.wrapped.getDeclaringClass());
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.hasNeverInlineDirective;
    }

    public boolean shouldBeInlined() {
        throw JVMCIError.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "AnalysisMethod<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", invoked: " + (this.isInvoked != null) + ", implInvoked: " + (this.isImplementationInvoked != null) + ", intrinsic: " + (this.isIntrinsicMethod != null) + ", inlined: " + (this.isInlined != null) + (this.isVirtualRootMethod() ? ", virtual root" : "") + (this.isDirectRootMethod() ? ", direct root" : "") + (this.isNativeEntryPoint() ? ", entry point" : "") + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw JVMCIError.unimplemented();
    }

    public Constant getEncoding() {
        throw JVMCIError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return false;
    }

    public boolean isDefault() {
        return this.wrapped.isDefault();
    }

    public SpeculationLog getSpeculationLog() {
        throw JVMCIError.shouldNotReachHere();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public ResolvedJavaMethod unwrapTowardsOriginalMethod() {
        return this.wrapped;
    }

    public Executable getJavaMethod() {
        if (this.wrapped instanceof BaseLayerMethod) {
            return null;
        }
        return OriginalMethodProvider.getJavaMethod(this);
    }

    public AnalysisParsedGraph reparseGraph(BigBang bb) {
        return this.ensureGraphParsedHelper(bb, AnalysisParsedGraph.Stage.finalStage(), true);
    }

    public Object getParsedGraphCacheStateObject() {
        return this.parsedGraphCacheState.get().get(AnalysisParsedGraph.Stage.finalStage());
    }

    public AnalysisParsedGraph ensureGraphParsed(BigBang bb) {
        return this.ensureGraphParsed(bb, AnalysisParsedGraph.Stage.finalStage());
    }

    public AnalysisParsedGraph ensureGraphParsed(BigBang bb, AnalysisParsedGraph.Stage stage) {
        return this.ensureGraphParsedHelper(bb, stage, false);
    }

    private AnalysisParsedGraph ensureGraphParsedHelper(BigBang bb, AnalysisParsedGraph.Stage stage, boolean forceReparse) {
        GraphCacheEntry curState;
        assert (AnalysisParsedGraph.Stage.isRequiredStage(stage, this));
        while (true) {
            if ((curState = this.parsedGraphCacheState.get()).isUnparsed(stage) || forceReparse && curState.isStageParsed(stage)) {
                AnalysisParsedGraph graph = this.isInBaseLayer && this.getUniverse().getImageLayerLoader().hasAnalysisParsedGraph(this) ? this.getBaseLayerGraph(bb, curState) : this.createAnalysisParsedGraph(bb, stage, curState, forceReparse);
                if (graph == null) continue;
                return graph;
            }
            if (!curState.isParsing(stage)) break;
            this.waitOnLock(stage, (ReentrantLock)curState.get(stage));
        }
        if (!forceReparse && curState.isStageParsed(stage)) {
            return (AnalysisParsedGraph)curState.get(stage);
        }
        if (curState.isParsingError()) {
            throw AnalysisError.shouldNotReachHere("parsing had failed in another thread", (Throwable)curState.get(stage));
        }
        if (curState.isCleared()) {
            return null;
        }
        throw AnalysisError.shouldNotReachHere("Unknown state: " + String.valueOf(curState));
    }

    private static GraphSupplier getGraphSupplierForStage(AnalysisParsedGraph.Stage stage, boolean forceReparse) {
        return switch (stage) {
            default -> throw new MatchException(null, null);
            case AnalysisParsedGraph.Stage.BYTECODE_PARSED -> CREATE_FIRST_STAGE;
            case AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED -> forceReparse ? REPARSE_FINAL_STAGE : CREATE_FINAL_STAGE;
        };
    }

    private AnalysisParsedGraph getBaseLayerGraph(BigBang bb, GraphCacheEntry expectedValue) {
        return this.setGraph(bb, AnalysisParsedGraph.Stage.finalStage(), expectedValue, GET_FROM_BASE_LAYER);
    }

    private AnalysisParsedGraph createAnalysisParsedGraph(BigBang bb, AnalysisParsedGraph.Stage stage, GraphCacheEntry curState, boolean forceReparse) {
        if (stage.hasPrevious() && AnalysisParsedGraph.Stage.isRequiredStage(stage.previous(), this) && !curState.isStageParsed(stage.previous())) {
            this.ensureGraphParsedHelper(bb, stage.previous(), forceReparse);
            return null;
        }
        return this.setGraph(bb, stage, curState, AnalysisMethod.getGraphSupplierForStage(stage, forceReparse));
    }

    private AnalysisParsedGraph setGraph(BigBang bb, AnalysisParsedGraph.Stage stage, GraphCacheEntry expectedValue, GraphSupplier graphSupplier) {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            GraphCacheEntry lockState = GraphCacheEntry.createLockEntry(stage, expectedValue, lock);
            if (!this.parsedGraphCacheState.compareAndSet(expectedValue, lockState)) {
                AnalysisParsedGraph analysisParsedGraph = null;
                return analysisParsedGraph;
            }
            GraphCacheEntry newEntry = graphSupplier.get(bb, this, expectedValue);
            boolean result = this.parsedGraphCacheState.compareAndSet(lockState, newEntry);
            AnalysisError.guarantee(result, "State transition failed", new Object[0]);
            AnalysisParsedGraph analysisParsedGraph = (AnalysisParsedGraph)newEntry.get(stage);
            if (stage == AnalysisParsedGraph.Stage.finalStage()) {
                this.persistTrackedGraph(analysisParsedGraph);
            }
            AnalysisParsedGraph analysisParsedGraph2 = analysisParsedGraph;
            return analysisParsedGraph2;
        }
        catch (Throwable ex) {
            this.parsedGraphCacheState.set(GraphCacheEntry.createParsingError(stage, expectedValue, ex));
            throw ex;
        }
        finally {
            lock.unlock();
        }
    }

    private void waitOnLock(AnalysisParsedGraph.Stage stage, ReentrantLock lock) {
        AnalysisError.guarantee(!lock.isHeldByCurrentThread(), "Recursive parsing request, would lead to endless waiting loop", new Object[0]);
        lock.lock();
        try {
            AnalysisError.guarantee(this.parsedGraphCacheState.get().get(stage) != lock, "Parsing must have finished in the thread that installed the lock", new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    public StructuredGraph decodeAnalyzedGraph(DebugContext debug, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences) {
        if (this.analyzedGraph == null) {
            return null;
        }
        return this.decodeAnalyzedGraph(debug, nodeReferences, this.analyzedGraph.trackNodeSourcePosition(), this.analyzedGraph.isRecordingInlinedMethods(), GraphDecoder::new);
    }

    public StructuredGraph decodeAnalyzedGraph(DebugContext debug, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences, boolean trackNodeSourcePosition, boolean recordInlinedMethods, BiFunction<Architecture, StructuredGraph, GraphDecoder> decoderProvider) {
        if (this.analyzedGraph == null) {
            return null;
        }
        StructuredGraph.AllowAssumptions allowAssumptions = this.getUniverse().hostVM().allowAssumptions(this);
        StructuredGraph result = new StructuredGraph.Builder(debug.getOptions(), debug, allowAssumptions).method((ResolvedJavaMethod)this).trackNodeSourcePosition(trackNodeSourcePosition).recordInlinedMethods(recordInlinedMethods).build();
        GraphDecoder decoder = decoderProvider.apply(AnalysisParsedGraph.HOST_ARCHITECTURE, result);
        decoder.decode(this.analyzedGraph, nodeReferences);
        switch (allowAssumptions) {
            case YES: {
                assert (this.analyzedGraph.getAssumptions().equals((Object)result.getAssumptions())) : this;
                break;
            }
            case NO: {
                assert (this.analyzedGraph.getAssumptions() == null && result.getAssumptions() == null) : this;
                break;
            }
        }
        return result;
    }

    public void setAnalyzedGraph(EncodedGraph analyzedGraph) {
        this.analyzedGraph = analyzedGraph;
    }

    public void clearAnalyzedGraph() {
        this.analyzedGraph = null;
    }

    public EncodedGraph getAnalyzedGraph() {
        return this.analyzedGraph;
    }

    public MultiMethod.MultiMethodKey getMultiMethodKey() {
        return this.multiMethodKey;
    }

    public AnalysisMethod getOrCreateMultiMethod(MultiMethod.MultiMethodKey key) {
        return this.getOrCreateMultiMethod(key, k -> {});
    }

    public AnalysisMethod getMultiMethod(MultiMethod.MultiMethodKey key) {
        if (key == this.multiMethodKey) {
            return this;
        }
        if (this.multiMethodMap == null) {
            return null;
        }
        return (AnalysisMethod)this.multiMethodMap.get(key);
    }

    public Collection<MultiMethod> getAllMultiMethods() {
        if (this.multiMethodMap == null) {
            return Collections.singleton(this);
        }
        return this.multiMethodMap.values();
    }

    public AnalysisMethod getOrCreateMultiMethod(MultiMethod.MultiMethodKey key, Consumer<AnalysisMethod> createAction) {
        if (key == this.multiMethodKey) {
            return this;
        }
        if (this.multiMethodMap == null) {
            ConcurrentHashMap<MultiMethod.MultiMethodKey, AnalysisMethod> newMultiMethodMap = new ConcurrentHashMap<MultiMethod.MultiMethodKey, AnalysisMethod>();
            newMultiMethodMap.put(this.multiMethodKey, this);
            MULTIMETHOD_MAP_UPDATER.compareAndSet(this, null, newMultiMethodMap);
        }
        return (AnalysisMethod)this.multiMethodMap.computeIfAbsent(key, k -> {
            AnalysisMethod newMethod = this.createMultiMethod(this, (MultiMethod.MultiMethodKey)k);
            createAction.accept(newMethod);
            return newMethod;
        });
    }

    public void setOpaqueReturn() {
        this.hasOpaqueReturn = true;
    }

    public boolean hasOpaqueReturn() {
        return this.hasOpaqueReturn;
    }

    protected abstract AnalysisMethod createMultiMethod(AnalysisMethod var1, MultiMethod.MultiMethodKey var2);

    private record GraphCacheEntry(Object bytecodeParsedObject, Object afterParsingHooksDoneObject) {
        private static final Object GRAPH_CACHE_UNPARSED = new Sentinel("unparsed");
        private static final Object GRAPH_CACHE_CLEARED = new Sentinel("cleared by cleanupAfterAnalysis");
        private static final GraphCacheEntry UNPARSED = new GraphCacheEntry(GRAPH_CACHE_UNPARSED, GRAPH_CACHE_UNPARSED);
        private static final GraphCacheEntry CLEARED = new GraphCacheEntry(GRAPH_CACHE_CLEARED, GRAPH_CACHE_CLEARED);

        private GraphCacheEntry {
            assert (!(afterParsingHooksDoneObject instanceof AnalysisParsedGraph) || bytecodeParsedObject instanceof AnalysisParsedGraph);
        }

        static GraphCacheEntry createLockEntry(AnalysisParsedGraph.Stage stage, GraphCacheEntry base, ReentrantLock lock) {
            return switch (stage) {
                default -> throw new MatchException(null, null);
                case AnalysisParsedGraph.Stage.BYTECODE_PARSED -> new GraphCacheEntry(lock, lock);
                case AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED -> base.bytecodeParsedObject == GRAPH_CACHE_UNPARSED ? new GraphCacheEntry(lock, lock) : new GraphCacheEntry(base.bytecodeParsedObject, lock);
            };
        }

        static GraphCacheEntry createParsingError(AnalysisParsedGraph.Stage stage, GraphCacheEntry base, Throwable throwable) {
            return switch (stage) {
                default -> throw new MatchException(null, null);
                case AnalysisParsedGraph.Stage.BYTECODE_PARSED -> new GraphCacheEntry(throwable, GRAPH_CACHE_UNPARSED);
                case AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED -> new GraphCacheEntry(base.bytecodeParsedObject, throwable);
            };
        }

        boolean isUnparsed(AnalysisParsedGraph.Stage stage) {
            return this.get(stage) == GRAPH_CACHE_UNPARSED;
        }

        private Object get(AnalysisParsedGraph.Stage stage) {
            return switch (stage) {
                default -> throw new MatchException(null, null);
                case AnalysisParsedGraph.Stage.BYTECODE_PARSED -> this.bytecodeParsedObject;
                case AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED -> this.afterParsingHooksDoneObject;
            };
        }

        boolean isParsing(AnalysisParsedGraph.Stage stage) {
            return this.get(stage) instanceof ReentrantLock;
        }

        boolean isStageParsed(AnalysisParsedGraph.Stage stage) {
            return this.get(stage) instanceof AnalysisParsedGraph;
        }

        boolean isParsingError() {
            assert (!(this.bytecodeParsedObject instanceof Throwable) || !(this.afterParsingHooksDoneObject instanceof Throwable));
            return this.bytecodeParsedObject instanceof Throwable || this.afterParsingHooksDoneObject instanceof Throwable;
        }

        boolean isCleared() {
            return this.bytecodeParsedObject == GRAPH_CACHE_CLEARED && this.afterParsingHooksDoneObject == GRAPH_CACHE_CLEARED;
        }

        @Override
        public String toString() {
            return String.format("GraphCacheState(%s, %s)", this.bytecodeParsedObject, this.afterParsingHooksDoneObject);
        }

        private record Sentinel(String description) {
            @Override
            public String toString() {
                return this.description;
            }
        }
    }

    @FunctionalInterface
    private static interface GraphSupplier {
        public GraphCacheEntry get(BigBang var1, AnalysisMethod var2, GraphCacheEntry var3);
    }

    public record Signature(String name, AnalysisType[] parameterTypes) {
    }
}

