/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.LambdaConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.util.StringUtil;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.util.json.JsonPrintable;

public interface ConfigurationTypeDescriptor
extends Comparable<ConfigurationTypeDescriptor>,
JsonPrintable {
    public static ConfigurationTypeDescriptor fromClass(Class<?> clazz) {
        Stream<String> interfacesStream = Arrays.stream(clazz.getInterfaces()).map(Class::getTypeName);
        if (Proxy.isProxyClass(clazz)) {
            return ProxyConfigurationTypeDescriptor.fromInterfaceReflectionNames(interfacesStream.toList());
        }
        if (LambdaUtils.isLambdaClass(clazz)) {
            String declaringClass = StringUtil.split((String)clazz.getTypeName(), (String)"$$Lambda")[0];
            return LambdaConfigurationTypeDescriptor.fromReflectionNames(declaringClass, interfacesStream.toList());
        }
        return NamedConfigurationTypeDescriptor.fromReflectionName(clazz.getTypeName());
    }

    public Kind getDescriptorType();

    public String toString();

    public Collection<String> getAllQualifiedJavaNames();

    public static enum Kind {
        NAMED,
        PROXY,
        LAMBDA;

    }
}

