/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class JsonFileWriter
implements Closeable {
    private final Object lock = new Object();
    private final BufferedWriter writer;
    private boolean open = true;
    private int written = 0;

    public JsonFileWriter(Path path) throws IOException {
        this.writer = Files.newBufferedWriter(path, new OpenOption[0]);
        JsonWriter json = new JsonWriter((Writer)this.writer);
        json.append('[').newline();
        json.flush();
    }

    public void printObject(EconomicMap<String, Object> entry) {
        try {
            StringWriter str = new StringWriter();
            try (JsonWriter json = new JsonWriter((Writer)str);){
                json.append('{');
                boolean first = true;
                MapCursor cursor = entry.getEntries();
                while (cursor.advance()) {
                    if (!first) {
                        json.append(", ");
                    }
                    json.quote((String)cursor.getKey()).append(':');
                    Object object = cursor.getValue();
                    if (object instanceof JsonPrintable) {
                        JsonPrintable value = (JsonPrintable)object;
                        value.printJson(json);
                    } else if (cursor.getValue() instanceof Object[]) {
                        JsonFileWriter.printArray(json, (Object[])cursor.getValue());
                    } else {
                        JsonFileWriter.printValue(json, cursor.getValue());
                    }
                    first = false;
                }
                json.append('}');
            }
            this.writeEntry(str.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("StringWriter should not throw IOExceptions", e);
        }
    }

    private static void printArray(JsonWriter json, Object[] array) throws IOException {
        json.append('[');
        for (int i = 0; i < array.length; ++i) {
            Object obj;
            if (i > 0) {
                json.append(',');
            }
            if ((obj = array[i]) instanceof Object[]) {
                JsonFileWriter.printArray(json, (Object[])obj);
                continue;
            }
            JsonFileWriter.printValue(json, array[i]);
        }
        json.append(']');
    }

    private static void printValue(JsonWriter json, Object value) throws IOException {
        if (value instanceof JsonPrintable) {
            JsonPrintable printable = (JsonPrintable)value;
            printable.printJson(json);
            return;
        }
        Object s = null;
        if (value instanceof byte[]) {
            s = Base64.getEncoder().encodeToString((byte[])value);
        } else if (value != null) {
            s = value;
        }
        json.printValue(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntry(String s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.open) {
                if (this.written > 0) {
                    this.writer.write(",\n");
                }
                this.writer.write(s);
                ++this.written;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.writer.write("\n]\n");
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.open = false;
        }
    }
}

