/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateInstalledCodeImpl;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilable;
import java.lang.ref.WeakReference;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CodePointer;

public class SubstrateOptimizedCallTargetInstalledCode
extends InstalledCode
implements SubstrateInstalledCode,
OptimizedAssumptionDependency {
    protected final WeakReference<SubstrateOptimizedCallTarget> callTargetRef;
    private String nameSuffix = "";
    private static final String NOT_CALLED_IN_SUBSTRATE_VM = "No implementation in Substrate VM";

    protected SubstrateOptimizedCallTargetInstalledCode(SubstrateOptimizedCallTarget callTarget) {
        super(null);
        this.callTargetRef = new WeakReference<SubstrateOptimizedCallTarget>(callTarget);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getAddress() {
        return this.address;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getEntryPoint() {
        return this.entryPoint;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAlive() {
        return this.address != 0L;
    }

    public final void invalidate() {
        CodeInfoTable.invalidateInstalledCode((SubstrateInstalledCode)this);
        SubstrateOptimizedCallTarget callTarget = (SubstrateOptimizedCallTarget)this.callTargetRef.get();
        if (callTarget != null) {
            callTarget.onInvalidate(null, null, true);
        }
    }

    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        boolean wasActive = false;
        if (this.isAlive()) {
            CodeInfoTable.invalidateInstalledCode((SubstrateInstalledCode)this);
            wasActive = true;
        } else assert (!this.isValid()) : "Cannot be valid but not alive";
        SubstrateOptimizedCallTarget callTarget = (SubstrateOptimizedCallTarget)this.callTargetRef.get();
        if (callTarget != null) {
            callTarget.onInvalidate(source, reason, wasActive);
        }
    }

    public boolean isValid() {
        return super.isValid();
    }

    public TruffleCompilable getCompilable() {
        return (TruffleCompilable)this.callTargetRef.get();
    }

    public SubstrateSpeculationLog getSpeculationLog() {
        SubstrateOptimizedCallTarget callTarget = (SubstrateOptimizedCallTarget)this.callTargetRef.get();
        if (callTarget != null) {
            return callTarget.getSpeculationLog();
        }
        return null;
    }

    public void setCompilationId(CompilationIdentifier id) {
        this.nameSuffix = " (" + id.toString(CompilationIdentifier.Verbosity.ID) + ")";
    }

    public String getName() {
        SubstrateOptimizedCallTarget callTarget = (SubstrateOptimizedCallTarget)this.callTargetRef.get();
        String targetName = callTarget != null ? callTarget.getName() : "<<collected-target>>";
        return targetName + this.nameSuffix;
    }

    public ResolvedJavaMethod getMethod() {
        return null;
    }

    public void setAddress(long address, long entryPoint, ResolvedJavaMethod method) {
        assert (VMOperation.isInProgressAtSafepoint());
        this.address = address;
        this.entryPoint = entryPoint;
        SubstrateOptimizedCallTarget target = (SubstrateOptimizedCallTarget)this.callTargetRef.get();
        if (target == null) {
            throw VMError.shouldNotReachHere((String)"Call target must not be collected during code installation.");
        }
        target.onCodeInstalled(this);
    }

    public void clearAddress() {
        assert (VMOperation.isInProgressAtSafepoint());
        this.entryPoint = 0L;
        this.address = 0L;
        SubstrateOptimizedCallTarget target = (SubstrateOptimizedCallTarget)this.callTargetRef.get();
        if (target != null) {
            target.onCodeCleared(this);
        }
    }

    public void makeNonEntrant() {
        assert (VMOperation.isInProgressAtSafepoint());
        if (this.isValid()) {
            this.makeNonEntrant0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must tether the CodeInfo.")
    private void makeNonEntrant0() {
        this.entryPoint = 0L;
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo((CodePointer)((CodePointer)Word.pointer((long)this.address)));
        assert (untetheredInfo.isNonNull() && !UntetheredCodeInfoAccess.isAOTImageCode((UntetheredCodeInfo)untetheredInfo));
        Object tether = CodeInfoAccess.acquireTether((UntetheredCodeInfo)untetheredInfo);
        try {
            CodeInfo codeInfo = CodeInfoAccess.convert((UntetheredCodeInfo)untetheredInfo, (Object)tether);
            CodeInfoAccess.setState((CodeInfo)codeInfo, (int)2);
            SubstrateOptimizedCallTargetInstalledCode.logMakeNonEntrant(codeInfo);
        }
        finally {
            CodeInfoAccess.releaseTether((UntetheredCodeInfo)untetheredInfo, (Object)tether);
        }
    }

    @Uninterruptible(reason="Call interruptible code now that the CodeInfo is tethered.", calleeMustBe=false)
    private static void logMakeNonEntrant(CodeInfo codeInfo) {
        RuntimeCodeInfoHistory.singleton().logMakeNonEntrant(codeInfo);
    }

    @Uninterruptible(reason="Must be safepoint free")
    static Object doInvoke(SubstrateOptimizedCallTarget callTarget, Object[] args) {
        long start = callTarget.installedCode.entryPoint;
        if (start != 0L) {
            SubstrateOptimizedCallTarget.CallBoundaryFunctionPointer target = (SubstrateOptimizedCallTarget.CallBoundaryFunctionPointer)Word.pointer((long)start);
            return target.invoke(callTarget, args);
        }
        return callTarget.invokeCallBoundary(args);
    }

    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    boolean isValidLastTier() {
        if (this.entryPoint == 0L) {
            return false;
        }
        UntetheredCodeInfo info = CodeInfoTable.lookupCodeInfo((CodePointer)((CodePointer)Word.pointer((long)this.entryPoint)));
        return info.isNonNull() && !UntetheredCodeInfoAccess.isAOTImageCode((UntetheredCodeInfo)info) && UntetheredCodeInfoAccess.getTier((UntetheredCodeInfo)info) == 2;
    }

    public long getStart() {
        return this.getAddress();
    }

    public byte[] getCode() {
        return SubstrateInstalledCodeImpl.getCode((CodePointer)((CodePointer)Word.pointer((long)this.entryPoint)));
    }

    public Object executeVarargs(Object ... args) {
        throw VMError.shouldNotReachHere((String)NOT_CALLED_IN_SUBSTRATE_VM);
    }
}

