/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile;

import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public final class ParserMethod {
    public static final ParserMethod[] EMPTY_ARRAY = new ParserMethod[0];
    private final int flags;
    private final Symbol<Name> name;
    private final Symbol<Signature> signature;
    private final Attribute[] attributes;

    public int getFlags() {
        return this.flags;
    }

    public static ParserMethod create(int flags, Symbol<Name> name, Symbol<Signature> signature, Attribute[] attributes) {
        return new ParserMethod(flags, name, signature, attributes);
    }

    public Symbol<Name> getName() {
        return this.name;
    }

    public Symbol<Signature> getSignature() {
        return this.signature;
    }

    public Attribute getAttribute(Symbol<Name> attributeName) {
        for (Attribute attribute : this.attributes) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    ParserMethod(int flags, Symbol<Name> name, Symbol<Signature> signature, Attribute[] attributes) {
        this.flags = flags;
        this.name = name;
        this.signature = signature;
        this.attributes = attributes;
    }
}

