/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public final class MethodParametersAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.MethodParameters;
    public static final MethodParametersAttribute EMPTY = new MethodParametersAttribute(NAME, Entry.EMPTY_ARRAY);
    private final Entry[] entries;

    public Entry[] getEntries() {
        return this.entries;
    }

    public MethodParametersAttribute(Symbol<Name> name, Entry[] entries) {
        assert (name == NAME);
        this.entries = entries;
    }

    @Override
    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (!super.isSame(other, thisPool, otherPool)) {
            return false;
        }
        MethodParametersAttribute that = (MethodParametersAttribute)other;
        return this.entriesSameAs(that.entries, thisPool, otherPool);
    }

    private boolean entriesSameAs(Entry[] otherEntries, ConstantPool thisPool, ConstantPool otherPool) {
        if (this.entries.length != otherEntries.length) {
            return false;
        }
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i].isSame(otherEntries[i], thisPool, otherPool)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }

    public static final class Entry {
        public static final Entry[] EMPTY_ARRAY = new Entry[0];
        private final int nameIndex;
        private final int accessFlags;

        public Entry(int nameIndex, int accessFlags) {
            this.nameIndex = nameIndex;
            this.accessFlags = accessFlags;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getAccessFlags() {
            return this.accessFlags;
        }

        public boolean isSame(Entry otherEntry, ConstantPool thisPool, ConstantPool otherPool) {
            return thisPool.isSame(this.nameIndex, otherEntry.nameIndex, otherPool) && this.accessFlags == otherEntry.accessFlags;
        }
    }
}

