/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.resolver;

import com.oracle.svm.espresso.classfile.bytecode.Bytecodes;

public enum CallSiteType {
    Static,
    Special,
    Virtual,
    Interface;


    public static CallSiteType fromOpCode(int opcode) {
        return switch (opcode) {
            case 184 -> Static;
            case 183 -> Special;
            case 182 -> Virtual;
            case 185 -> Interface;
            default -> throw new IllegalStateException(CallSiteType.unexpectedBytecodeError(opcode));
        };
    }

    private static String unexpectedBytecodeError(int opcode) {
        return "Unexpected bytecode " + Bytecodes.nameOf(opcode);
    }
}

