/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.shared.verifier.StackMapFrame;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;
import java.io.PrintStream;

final class FullFrame
extends StackMapFrame {
    private final int offsetDelta;
    private final VerificationTypeInfo[] locals;
    private final VerificationTypeInfo[] stack;

    FullFrame(int frameType, int offsetDelta, VerificationTypeInfo[] locals, VerificationTypeInfo[] stack) {
        super(frameType);
        this.offsetDelta = offsetDelta;
        this.locals = locals;
        this.stack = stack;
    }

    @Override
    public int getOffset() {
        return this.offsetDelta;
    }

    @Override
    public VerificationTypeInfo[] getLocals() {
        return this.locals;
    }

    @Override
    public VerificationTypeInfo[] getStack() {
        return this.stack;
    }

    @Override
    public void print(ConstantPool pool, PrintStream out) {
        super.print(pool, out);
        out.println("            Locals: [");
        for (VerificationTypeInfo vti : this.locals) {
            out.println("                " + vti.toString(pool));
        }
        out.println("            ]");
        out.println("            Stack: [");
        for (VerificationTypeInfo vti : this.stack) {
            out.println("                " + vti.toString(pool));
        }
        out.println("            ]");
        out.println("        }");
    }
}

