/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.locale;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.locale.LocaleCHelper;
import com.oracle.svm.core.c.locale.LocaleData;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@AutomaticallyRegisteredImageSingleton
public class LocaleSupport {
    private static final CGlobalData<Pointer> STATE = CGlobalDataFactory.createWord((WordBase)State.UNINITIALIZED);
    private LocaleData locale;

    @Fold
    public static LocaleSupport singleton() {
        return (LocaleSupport)ImageSingletons.lookup(LocaleSupport.class);
    }

    @Fold
    static boolean isSystemSpecificLocaleSupported() {
        return LibC.isSupported() && SubstrateOptions.UseSystemLocale.getValue() != false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize() {
        if (!LocaleSupport.isSystemSpecificLocaleSupported()) {
            return;
        }
        Pointer statePtr = STATE.get();
        UnsignedWord value = (UnsignedWord)statePtr.compareAndSwapWord(0, (WordBase)State.UNINITIALIZED, (WordBase)State.INITIALIZING, LocationIdentity.ANY_LOCATION);
        if (value == State.UNINITIALIZED) {
            int result = LocaleCHelper.initializeLocale();
            if (result == LocaleCHelper.SVM_LOCALE_INITIALIZATION_SUCCEEDED()) {
                statePtr.writeWordVolatile(0, (WordBase)State.SUCCESS);
                return;
            } else {
                if (result != LocaleCHelper.SVM_LOCALE_INITIALIZATION_OUT_OF_MEMORY()) throw VMError.shouldNotReachHere("LocaleCHelper.initializeLocale() returned an unexpected result.");
                statePtr.writeWordVolatile(0, (WordBase)State.OUT_OF_MEMORY);
            }
            return;
        } else {
            while (value == State.INITIALIZING) {
                PauseNode.pause();
                value = (UnsignedWord)statePtr.readWordVolatile(0, LocationIdentity.ANY_LOCATION);
            }
        }
    }

    public static void checkForError() {
        if (!LocaleSupport.isSystemSpecificLocaleSupported()) {
            return;
        }
        UnsignedWord state = (UnsignedWord)STATE.get().readWord(0);
        if (state != State.SUCCESS) {
            if (state == State.OUT_OF_MEMORY) {
                throw new OutOfMemoryError("Not enough native memory to initialize the locale support.");
            }
            throw VMError.shouldNotReachHere("Locale support had an unexpected state after initialization.");
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+5/src/java.base/share/classes/jdk/internal/util/SystemProps.java#L131-L141")
    public synchronized LocaleData getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (!LocaleSupport.isSystemSpecificLocaleSupported()) {
            String country = "US";
            String language = "en";
            this.locale = new LocaleData(country, null, null, language, null, null, null, null, null, null, null, null);
            return this.locale;
        }
        assert (STATE.get().readWord(0) == State.SUCCESS);
        LocaleCHelper.LocaleProps props = LocaleCHelper.getLocale();
        String defaultCountry = CTypeConversion.toJavaString((CCharPointer)props.displayCountry());
        String defaultCountryDisplay = CTypeConversion.toJavaString((CCharPointer)props.displayCountry());
        String defaultCountryFormat = CTypeConversion.toJavaString((CCharPointer)props.formatCountry());
        String defaultLanguage = CTypeConversion.toJavaString((CCharPointer)props.displayLanguage());
        String defaultLanguageDisplay = CTypeConversion.toJavaString((CCharPointer)props.displayLanguage());
        String defaultLanguageFormat = CTypeConversion.toJavaString((CCharPointer)props.formatLanguage());
        String defaultScript = CTypeConversion.toJavaString((CCharPointer)props.displayScript());
        String defaultScriptDisplay = CTypeConversion.toJavaString((CCharPointer)props.displayScript());
        String defaultScriptFormat = CTypeConversion.toJavaString((CCharPointer)props.formatScript());
        String defaultVariant = CTypeConversion.toJavaString((CCharPointer)props.displayVariant());
        String defaultVariantDisplay = CTypeConversion.toJavaString((CCharPointer)props.displayVariant());
        String defaultVariantFormat = CTypeConversion.toJavaString((CCharPointer)props.formatVariant());
        LocaleAspect country = LocaleSupport.getLocaleAspect("user.country", "user.country.display", "user.country.format", defaultCountry, defaultCountryDisplay, defaultCountryFormat);
        LocaleAspect language = LocaleSupport.getLocaleAspect("user.language", "user.language.display", "user.language.format", defaultLanguage, defaultLanguageDisplay, defaultLanguageFormat);
        LocaleAspect script = LocaleSupport.getLocaleAspect("user.script", "user.script.display", "user.script.format", defaultScript, defaultScriptDisplay, defaultScriptFormat);
        LocaleAspect variant = LocaleSupport.getLocaleAspect("user.variant", "user.variant.display", "user.variant.format", defaultVariant, defaultVariantDisplay, defaultVariantFormat);
        this.locale = new LocaleData(country.base, country.display, country.format, language.base, language.display, language.format, script.base, script.display, script.format, variant.base, variant.display, variant.format);
        return this.locale;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+5/src/java.base/share/classes/jdk/internal/util/SystemProps.java#L178-L209")
    private static LocaleAspect getLocaleAspect(String baseKey, String displayKey, String formatKey, String defaultBase, String defaultDisplay, String defaultFormat) {
        String base = SystemPropertiesSupport.singleton().getInitialProperty(baseKey, false);
        String display = SystemPropertiesSupport.singleton().getInitialProperty(displayKey, false);
        String format = SystemPropertiesSupport.singleton().getInitialProperty(formatKey, false);
        if (base == null) {
            base = defaultBase;
            if (display == null && defaultDisplay != null && !defaultDisplay.equals(base)) {
                display = defaultDisplay;
            }
            if (format == null && defaultFormat != null && !defaultFormat.equals(base)) {
                format = defaultFormat;
            }
        }
        return new LocaleAspect(base, display, format);
    }

    private static final class State {
        static final UnsignedWord UNINITIALIZED = Word.unsigned((int)0);
        static final UnsignedWord INITIALIZING = Word.unsigned((int)1);
        static final UnsignedWord SUCCESS = Word.unsigned((int)2);
        static final UnsignedWord OUT_OF_MEMORY = Word.unsigned((int)3);

        private State() {
        }
    }

    private record LocaleAspect(String base, String display, String format) {
    }
}

