/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.compacting.ObjectRefFixupVisitor;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.UninterruptibleObjectVisitor;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.lang.ref.Reference;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;

public final class ObjectFixupVisitor
implements UninterruptibleObjectVisitor {
    private final ObjectRefFixupVisitor refFixupVisitor;

    public ObjectFixupVisitor(ObjectRefFixupVisitor refFixupVisitor) {
        this.refFixupVisitor = refFixupVisitor;
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).", callerMustBe=true)
    public void visitObject(Object obj) {
        DynamicHub hub = KnownIntrinsics.readHub(obj);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)hub.isReferenceInstanceClass())) {
            Reference dr = (Reference)obj;
            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            this.refFixupVisitor.visitObjectReferences(ReferenceInternals.getReferentFieldAddress(dr), true, referenceSize, dr, 1);
        }
        InteriorObjRefWalker.walkObjectInline(obj, this.refFixupVisitor);
    }
}

