/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.deopt.DeoptimizationSlotPacking;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64Backend;
import com.oracle.svm.core.graal.code.InterpreterAccessStubData;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.AllocatableValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public class AArch64InterpreterStubs {
    public static final Register TRAMPOLINE_ARGUMENT = AArch64.r12;

    public static int sizeOfInterpreterData() {
        return NumUtil.roundUp((int)SizeOf.get(InterpreterDataAArch64.class), (int)16);
    }

    public static int additionalFrameSizeEnterStub() {
        int wordSize = 8;
        int deoptSlotSize = wordSize + wordSize;
        return AArch64InterpreterStubs.sizeOfInterpreterData() + deoptSlotSize;
    }

    public static int additionalFrameSizeLeaveStub() {
        int wordSize = 8;
        return 4 * wordSize;
    }

    @Fold
    public static int offsetAbiSpReg() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiSpReg");
    }

    @Fold
    public static int offsetAbiGpArg0() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg0");
    }

    @Fold
    public static int offsetAbiGpArg1() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg1");
    }

    @Fold
    public static int offsetAbiGpArg2() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg2");
    }

    @Fold
    public static int offsetAbiGpArg3() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg3");
    }

    @Fold
    public static int offsetAbiGpArg4() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg4");
    }

    @Fold
    public static int offsetAbiGpArg5() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg5");
    }

    @Fold
    public static int offsetAbiGpArg6() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg6");
    }

    @Fold
    public static int offsetAbiGpArg7() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpArg7");
    }

    @Fold
    public static int offsetAbiFpArg0() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg0");
    }

    @Fold
    public static int offsetAbiFpArg1() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg1");
    }

    @Fold
    public static int offsetAbiFpArg2() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg2");
    }

    @Fold
    public static int offsetAbiFpArg3() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg3");
    }

    @Fold
    public static int offsetAbiFpArg4() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg4");
    }

    @Fold
    public static int offsetAbiFpArg5() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg5");
    }

    @Fold
    public static int offsetAbiFpArg6() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg6");
    }

    @Fold
    public static int offsetAbiFpArg7() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpArg7");
    }

    @Fold
    public static int offsetAbiFpRet() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiFpRet");
    }

    @Fold
    public static int offsetAbiGpRet() {
        return OffsetOf.get(InterpreterDataAArch64.class, "AbiGpRet");
    }

    @RawStructure
    public static interface InterpreterDataAArch64
    extends PointerBase {
        @RawField
        public long getStackSize();

        @RawField
        public void setStackSize(long var1);

        @RawField
        public long getAbiSpReg();

        @RawField
        public void setAbiSpReg(long var1);

        @RawField
        public long getAbiGpArg0();

        @RawField
        public void setAbiGpArg0(long var1);

        @RawField
        public long getAbiGpArg1();

        @RawField
        public void setAbiGpArg1(long var1);

        @RawField
        public long getAbiGpArg2();

        @RawField
        public void setAbiGpArg2(long var1);

        @RawField
        public long getAbiGpArg3();

        @RawField
        public void setAbiGpArg3(long var1);

        @RawField
        public long getAbiGpArg4();

        @RawField
        public void setAbiGpArg4(long var1);

        @RawField
        public long getAbiGpArg5();

        @RawField
        public void setAbiGpArg5(long var1);

        @RawField
        public long getAbiGpArg6();

        @RawField
        public void setAbiGpArg6(long var1);

        @RawField
        public long getAbiGpArg7();

        @RawField
        public void setAbiGpArg7(long var1);

        @RawField
        public long getAbiFpArg0();

        @RawField
        public void setAbiFpArg0(long var1);

        @RawField
        public long getAbiFpArg1();

        @RawField
        public void setAbiFpArg1(long var1);

        @RawField
        public long getAbiFpArg2();

        @RawField
        public void setAbiFpArg2(long var1);

        @RawField
        public long getAbiFpArg3();

        @RawField
        public void setAbiFpArg3(long var1);

        @RawField
        public long getAbiFpArg4();

        @RawField
        public void setAbiFpArg4(long var1);

        @RawField
        public long getAbiFpArg5();

        @RawField
        public void setAbiFpArg5(long var1);

        @RawField
        public long getAbiFpArg6();

        @RawField
        public void setAbiFpArg6(long var1);

        @RawField
        public long getAbiFpArg7();

        @RawField
        public void setAbiFpArg7(long var1);

        @RawField
        public void setAbiGpRet(long var1);

        @RawField
        public long getAbiGpRet();

        @RawField
        public void setAbiFpRet(long var1);

        @RawField
        public long getAbiFpRet();
    }

    public static class AArch64InterpreterAccessStubData
    implements InterpreterAccessStubData {
        @Override
        public void setSp(Pointer data, int stackSize, Pointer stackBuffer) {
            VMError.guarantee(stackBuffer.isNonNull());
            InterpreterDataAArch64 p = (InterpreterDataAArch64)data;
            p.setAbiSpReg(stackBuffer.rawValue());
            p.setStackSize(stackSize);
            assert (stackSize % 16 == 0);
            stackBuffer.writeLong(0, DeoptimizationSlotPacking.encodeVariableFrameSizeIntoDeoptSlot(stackSize));
        }

        @Override
        public long getGpArgumentAt(AllocatableValue ccArg, Pointer data, int pos) {
            InterpreterDataAArch64 p = (InterpreterDataAArch64)data;
            return switch (pos) {
                case 0 -> p.getAbiGpArg0();
                case 1 -> p.getAbiGpArg1();
                case 2 -> p.getAbiGpArg2();
                case 3 -> p.getAbiGpArg3();
                case 4 -> p.getAbiGpArg4();
                case 5 -> p.getAbiGpArg5();
                case 6 -> p.getAbiGpArg6();
                case 7 -> p.getAbiGpArg7();
                default -> {
                    StackSlot stackSlot = (StackSlot)ccArg;
                    Pointer spVal = (Pointer)Word.pointer((long)p.getAbiSpReg());
                    yield spVal.readLong(stackSlot.getOffset(0));
                }
            };
        }

        @Override
        public long setGpArgumentAt(AllocatableValue ccArg, Pointer data, int pos, long val) {
            InterpreterDataAArch64 p = (InterpreterDataAArch64)data;
            if (pos >= 0 && pos <= 7) {
                VMError.guarantee(ccArg instanceof RegisterValue);
                switch (pos) {
                    case 0: {
                        p.setAbiGpArg0(val);
                        break;
                    }
                    case 1: {
                        p.setAbiGpArg1(val);
                        break;
                    }
                    case 2: {
                        p.setAbiGpArg2(val);
                        break;
                    }
                    case 3: {
                        p.setAbiGpArg3(val);
                        break;
                    }
                    case 4: {
                        p.setAbiGpArg4(val);
                        break;
                    }
                    case 5: {
                        p.setAbiGpArg5(val);
                        break;
                    }
                    case 6: {
                        p.setAbiGpArg6(val);
                        break;
                    }
                    case 7: {
                        p.setAbiGpArg7(val);
                    }
                }
                return 0L;
            }
            StackSlot stackSlot = (StackSlot)ccArg;
            Pointer spVal = (Pointer)Word.pointer((long)p.getAbiSpReg());
            int offset = stackSlot.getOffset(0);
            VMError.guarantee(spVal.isNonNull());
            VMError.guarantee((long)offset < p.getStackSize());
            spVal.writeLong(offset, val);
            VMError.guarantee(pos - 8 < 64, "more than 64 stack args are not supported");
            return 1L << pos - 8;
        }

        @Override
        public long getFpArgumentAt(AllocatableValue ccArg, Pointer data, int pos) {
            InterpreterDataAArch64 p = (InterpreterDataAArch64)data;
            return switch (pos) {
                case 0 -> p.getAbiFpArg0();
                case 1 -> p.getAbiFpArg1();
                case 2 -> p.getAbiFpArg2();
                case 3 -> p.getAbiFpArg3();
                case 4 -> p.getAbiFpArg4();
                case 5 -> p.getAbiFpArg5();
                case 6 -> p.getAbiFpArg6();
                case 7 -> p.getAbiFpArg7();
                default -> {
                    StackSlot stackSlot = (StackSlot)ccArg;
                    Pointer spVal = (Pointer)Word.pointer((long)p.getAbiSpReg());
                    yield spVal.readLong(stackSlot.getOffset(0));
                }
            };
        }

        @Override
        public void setFpArgumentAt(AllocatableValue ccArg, Pointer data, int pos, long val) {
            InterpreterDataAArch64 p = (InterpreterDataAArch64)data;
            switch (pos) {
                case 0: {
                    p.setAbiFpArg0(val);
                    break;
                }
                case 1: {
                    p.setAbiFpArg1(val);
                    break;
                }
                case 2: {
                    p.setAbiFpArg2(val);
                    break;
                }
                case 3: {
                    p.setAbiFpArg3(val);
                    break;
                }
                case 4: {
                    p.setAbiFpArg4(val);
                    break;
                }
                case 5: {
                    p.setAbiFpArg5(val);
                    break;
                }
                case 6: {
                    p.setAbiFpArg6(val);
                    break;
                }
                case 7: {
                    p.setAbiFpArg7(val);
                    break;
                }
                default: {
                    StackSlot stackSlot = (StackSlot)ccArg;
                    Pointer spVal = (Pointer)Word.pointer((long)p.getAbiSpReg());
                    int offset = stackSlot.getOffset(0);
                    VMError.guarantee(spVal.isNonNull());
                    VMError.guarantee((long)offset < p.getStackSize());
                    spVal.writeLong(offset, val);
                }
            }
        }

        @Override
        public long getGpReturn(Pointer data) {
            return ((InterpreterDataAArch64)data).getAbiGpRet();
        }

        @Override
        public void setGpReturn(Pointer data, long gpReturn) {
            ((InterpreterDataAArch64)data).setAbiGpRet(gpReturn);
        }

        @Override
        public long getFpReturn(Pointer data) {
            return ((InterpreterDataAArch64)data).getAbiFpRet();
        }

        @Override
        public void setFpReturn(Pointer data, long fpReturn) {
            ((InterpreterDataAArch64)data).setAbiFpRet(fpReturn);
        }

        @Override
        @Fold
        public int allocateStubDataSize() {
            return AArch64InterpreterStubs.sizeOfInterpreterData();
        }
    }

    public static class InterpreterLeaveStubContext
    extends SubstrateAArch64Backend.SubstrateAArch64FrameContext {
        public InterpreterLeaveStubContext(SharedMethod method) {
            super(method);
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            super.enter(crb);
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            masm.str(64, AArch64.r1, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.sp, (int)0));
            masm.str(64, AArch64.r2, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.sp, (int)8));
            masm.str(64, AArch64.r3, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.sp, (int)16));
            masm.sub(64, AArch64.sp, AArch64.sp, AArch64.r2);
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            Register callTarget = AArch64.r11;
            masm.mov(64, callTarget, AArch64.r0);
            masm.mov(64, AArch64.r0, AArch64.r1);
            Register stackSize = AArch64.r2;
            Label regsHandling = new Label();
            masm.cbz(64, stackSize, regsHandling);
            Register calleeSpArgs = AArch64.r4;
            Register interpDataSp = AArch64.r1;
            masm.ldr(64, interpDataSp, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiSpReg()));
            masm.mov(64, calleeSpArgs, AArch64.sp);
            int wordSize = 8;
            Label spCopyBegin = new Label();
            masm.bind(spCopyBegin);
            masm.ldr(64, AArch64.r3, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, (Register)interpDataSp, (int)wordSize));
            masm.str(64, AArch64.r3, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, (Register)calleeSpArgs, (int)wordSize));
            masm.sub(64, stackSize, stackSize, wordSize);
            masm.cbnz(64, stackSize, spCopyBegin);
            masm.bind(regsHandling);
            masm.fldr(64, AArch64.v7, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg7()));
            masm.fldr(64, AArch64.v6, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg6()));
            masm.fldr(64, AArch64.v5, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg5()));
            masm.fldr(64, AArch64.v4, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg4()));
            masm.fldr(64, AArch64.v3, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg3()));
            masm.fldr(64, AArch64.v2, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg2()));
            masm.fldr(64, AArch64.v1, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg1()));
            masm.fldr(64, AArch64.v0, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpArg0()));
            masm.ldr(64, AArch64.r7, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg7()));
            masm.ldr(64, AArch64.r6, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg6()));
            masm.ldr(64, AArch64.r5, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg5()));
            masm.ldr(64, AArch64.r4, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg4()));
            masm.ldr(64, AArch64.r3, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg3()));
            masm.ldr(64, AArch64.r2, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg2()));
            masm.ldr(64, AArch64.r1, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg1()));
            masm.ldr(64, AArch64.r0, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpArg0()));
            masm.blr(callTarget);
            try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
                Register resultCopy = scratchRegister.getRegister();
                masm.mov(64, resultCopy, AArch64.r0);
                masm.ldr(64, AArch64.r2, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.sp, (int)0));
                assert (crb.target.stackAlignment == 16);
                masm.lsr(64, AArch64.r2, AArch64.r2, 52L);
                masm.add(64, AArch64.sp, AArch64.sp, AArch64.r2);
                masm.ldr(64, AArch64.r0, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.sp, (int)0));
                masm.str(64, resultCopy, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpRet()));
            }
            masm.fstr(64, AArch64.v0, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpRet()));
            super.leave(crb);
        }
    }

    public static class InterpreterEnterStubContext
    extends SubstrateAArch64Backend.SubstrateAArch64FrameContext {
        public InterpreterEnterStubContext(SharedMethod method) {
            super(method);
        }

        private static AArch64Address createImmediate(int offset) {
            int deoptSlotSize = 16;
            return AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.sp, (int)(deoptSlotSize + offset));
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            Register trampArg = TRAMPOLINE_ARGUMENT;
            Register spCopy = AArch64.r11;
            masm.mov(64, spCopy, AArch64.sp);
            super.enter(crb);
            masm.str(64, spCopy, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiSpReg()));
            masm.str(64, AArch64.r0, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg0()));
            masm.str(64, AArch64.r1, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg1()));
            masm.str(64, AArch64.r2, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg2()));
            masm.str(64, AArch64.r3, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg3()));
            masm.str(64, AArch64.r4, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg4()));
            masm.str(64, AArch64.r5, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg5()));
            masm.str(64, AArch64.r6, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg6()));
            masm.str(64, AArch64.r7, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiGpArg7()));
            masm.fstr(64, AArch64.v0, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg0()));
            masm.fstr(64, AArch64.v1, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg1()));
            masm.fstr(64, AArch64.v2, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg2()));
            masm.fstr(64, AArch64.v3, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg3()));
            masm.fstr(64, AArch64.v4, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg4()));
            masm.fstr(64, AArch64.v5, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg5()));
            masm.fstr(64, AArch64.v6, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg6()));
            masm.fstr(64, AArch64.v7, InterpreterEnterStubContext.createImmediate(AArch64InterpreterStubs.offsetAbiFpArg7()));
            masm.add(64, AArch64.r1, AArch64.sp, 16);
            masm.mov(64, AArch64.r0, trampArg);
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            masm.fldr(64, AArch64.v0, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiFpRet()));
            masm.ldr(64, AArch64.r0, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)AArch64.r0, (int)AArch64InterpreterStubs.offsetAbiGpRet()));
            super.leave(crb);
        }
    }
}

