/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.VMConstant;

public final class TLABObjectHeaderConstant
implements JavaConstant,
VMConstant {
    private final JavaConstant hub;
    private final int size;

    public TLABObjectHeaderConstant(JavaConstant hub, int size) {
        assert (size == 4 || size == 8) : size;
        this.hub = hub;
        this.size = size;
    }

    public JavaConstant hub() {
        return this.hub;
    }

    public JavaKind getJavaKind() {
        return this.size == 4 ? JavaKind.Int : JavaKind.Long;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public Object asBoxedPrimitive() {
        return null;
    }

    public int asInt() {
        assert (this.getJavaKind() == JavaKind.Int);
        return (int)this.asLong();
    }

    public boolean asBoolean() {
        assert (false);
        return false;
    }

    public long asLong() {
        return this.getJavaKind() == JavaKind.Int ? -559030611L : -2401018187971961171L;
    }

    public float asFloat() {
        assert (false);
        return 0.0f;
    }

    public double asDouble() {
        assert (false);
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof TLABObjectHeaderConstant)) return false;
        TLABObjectHeaderConstant c = (TLABObjectHeaderConstant)o;
        if (!this.hub.equals((Object)c.hub)) return false;
        if (this.size != c.size) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.hub, this.size);
    }

    public String toValueString() {
        return "TLAB object header of " + this.hub().toValueString();
    }

    public String toString() {
        return "TLAB object header of " + this.hub().toString();
    }
}

