/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedType;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.InstanceOfSnippetsTemplates;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

public class OpenTypeWorldSnippets
extends SubstrateTemplates
implements Snippets {
    final SnippetTemplate.SnippetInfo instanceOf;
    final SnippetTemplate.SnippetInfo instanceOfDynamic;
    final SnippetTemplate.SnippetInfo typeEquality;
    final SnippetTemplate.SnippetInfo assignableTypeCheck;

    @Snippet
    protected static SubstrateIntrinsics.Any typeEqualitySnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, @Snippet.NonNullParameter DynamicHub exactType) {
        if (allowsNull) {
            if (BranchProbabilityNode.probability((double)0.09999999999999998, (object == null ? 1 : 0) != 0)) {
                return trueValue;
            }
            GuardingNode guard = SnippetAnchorNode.anchor();
            Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
            DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
            if (BranchProbabilityNode.probability((double)0.09999999999999998, (nonNullHub != exactType ? 1 : 0) != 0)) {
                return falseValue;
            }
            return trueValue;
        }
        DynamicHub hubOrNull = SubstrateIntrinsics.loadHubOrNull(object);
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (hubOrNull != exactType ? 1 : 0) != 0)) {
            return falseValue;
        }
        return trueValue;
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfSnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, @Snippet.ConstantParameter int typeID, @Snippet.ConstantParameter int typeIDDepth) {
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (object == null ? 1 : 0) != 0)) {
            if (allowsNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
        DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
        if (typeIDDepth >= 0) {
            return OpenTypeWorldSnippets.classTypeCheck(typeID, typeIDDepth, nonNullHub, trueValue, falseValue);
        }
        return OpenTypeWorldSnippets.interfaceTypeCheck(typeID, nonNullHub, trueValue, falseValue);
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfDynamicSnippet(@Snippet.NonNullParameter DynamicHub type, Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull) {
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (object == null ? 1 : 0) != 0)) {
            if (allowsNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
        DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
        int typeIDDepth = type.getTypeIDDepth();
        int typeIDToMatch = type.getTypeID();
        if (BranchProbabilityNode.unknownProbability((typeIDDepth >= 0 ? 1 : 0) != 0)) {
            return OpenTypeWorldSnippets.classTypeCheck(typeIDToMatch, typeIDDepth, nonNullHub, trueValue, falseValue);
        }
        return OpenTypeWorldSnippets.interfaceTypeCheck(typeIDToMatch, nonNullHub, trueValue, falseValue);
    }

    @Snippet
    protected static SubstrateIntrinsics.Any classIsAssignableFromSnippet(@Snippet.NonNullParameter DynamicHub type, @Snippet.NonNullParameter DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue) {
        int typeID = type.getTypeID();
        int typeIDDepth = type.getTypeIDDepth();
        if (BranchProbabilityNode.unknownProbability((typeIDDepth >= 0 ? 1 : 0) != 0)) {
            return OpenTypeWorldSnippets.classTypeCheck(typeID, typeIDDepth, checkedHub, trueValue, falseValue);
        }
        return OpenTypeWorldSnippets.interfaceTypeCheck(typeID, checkedHub, trueValue, falseValue);
    }

    protected static SubstrateIntrinsics.Any classTypeCheck(int typeID, int typeIDDepth, DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue) {
        int offset;
        int numClassTypes = checkedHub.getNumClassTypes();
        if (typeIDDepth >= numClassTypes) {
            return falseValue;
        }
        int[] checkedTypeIds = checkedHub.getOpenTypeWorldTypeCheckSlots();
        int checkedClassId = ObjectAccess.readInt((Object)checkedTypeIds, (int)(offset = (int)((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getArrayElementOffset(JavaKind.Int, typeIDDepth)), (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
        if (checkedClassId == typeID) {
            return trueValue;
        }
        return falseValue;
    }

    protected static SubstrateIntrinsics.Any interfaceTypeCheck(int typeID, DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue) {
        int numClassTypes = checkedHub.getNumClassTypes();
        int numInterfaceTypes = checkedHub.getNumInterfaceTypes();
        int[] checkedTypeIds = checkedHub.getOpenTypeWorldTypeCheckSlots();
        for (int i = 0; i < numInterfaceTypes * 2; i += 2) {
            int offset = (int)((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getArrayElementOffset(JavaKind.Int, numClassTypes + i);
            int checkedInterfaceId = ObjectAccess.readInt((Object)checkedTypeIds, (int)offset, (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
            if (checkedInterfaceId != typeID) continue;
            return trueValue;
        }
        return falseValue;
    }

    public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, Providers providers) {
        lowerings.put(InstanceOfNode.class, new InstanceOfLowering(this.options, providers));
        lowerings.put(InstanceOfDynamicNode.class, new InstanceOfDynamicLowering(this.options, providers));
        lowerings.put(ClassIsAssignableFromNode.class, new ClassIsAssignableFromLowering(this.options, providers));
    }

    protected OpenTypeWorldSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.instanceOf = this.snippet(providers, OpenTypeWorldSnippets.class, "instanceOfSnippet", new LocationIdentity[0]);
        this.instanceOfDynamic = this.snippet(providers, OpenTypeWorldSnippets.class, "instanceOfDynamicSnippet", new LocationIdentity[0]);
        this.typeEquality = this.snippet(providers, OpenTypeWorldSnippets.class, "typeEqualitySnippet", new LocationIdentity[0]);
        this.assignableTypeCheck = this.snippet(providers, OpenTypeWorldSnippets.class, "classIsAssignableFromSnippet", new LocationIdentity[0]);
    }

    protected class InstanceOfLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public InstanceOfLowering(OptionValues options, Providers providers) {
            super(options, providers);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.MID_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            InstanceOfNode node = (InstanceOfNode)replacer.instanceOf;
            TypeReference typeReference = node.type();
            SharedType type = (SharedType)typeReference.getType();
            DynamicHub hub = type.getHub();
            if (typeReference.isExact()) {
                args = new SnippetTemplate.Arguments(OpenTypeWorldSnippets.this.typeEquality, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getValue());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.add("allowsNull", (Object)node.allowsNull());
                args.add("exactType", (Object)hub);
            } else {
                args = this.makeArgumentsForInexactType(replacer, tool, node, type, hub);
            }
            return args;
        }

        protected SnippetTemplate.Arguments makeArgumentsForInexactType(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool, InstanceOfNode node, SharedType type, DynamicHub hub) {
            assert (type.getSingleImplementor() == null) : "Canonicalization of InstanceOfNode produces exact type for single implementor";
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(OpenTypeWorldSnippets.this.instanceOf, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", (Object)node.getValue());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.add("allowsNull", (Object)node.allowsNull());
            args.add("typeID", (Object)hub.getTypeID());
            args.add("typeIDDepth", (Object)hub.getTypeIDDepth());
            return args;
        }
    }

    protected class InstanceOfDynamicLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public InstanceOfDynamicLowering(OptionValues options, Providers providers) {
            super(options, providers);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.MID_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            InstanceOfDynamicNode node = (InstanceOfDynamicNode)replacer.instanceOf;
            if (node.isExact()) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(OpenTypeWorldSnippets.this.typeEquality, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getObject());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.add("allowsNull", (Object)node.allowsNull());
                args.add("exactType", (Object)node.getMirrorOrHub());
                return args;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(OpenTypeWorldSnippets.this.instanceOfDynamic, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", (Object)node.getMirrorOrHub());
            args.add("object", (Object)node.getObject());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.add("allowsNull", (Object)node.allowsNull());
            return args;
        }
    }

    protected class ClassIsAssignableFromLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public ClassIsAssignableFromLowering(OptionValues options, Providers providers) {
            super(options, providers);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.MID_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            ClassIsAssignableFromNode node = (ClassIsAssignableFromNode)replacer.instanceOf;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(OpenTypeWorldSnippets.this.assignableTypeCheck, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", (Object)node.getThisClass());
            args.add("checkedHub", (Object)node.getOtherClass());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            return args;
        }
    }
}

