/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.CremaSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import java.security.ProtectionDomain;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionKey;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.ClassLoadingSupport;

public class RuntimeClassLoading {
    private static final String DEFINITION_NOT_SUPPORTED_MESSAGE = "To make this work, you have the following options:\n  1) Modify or reconfigure your application (or a third-party library) so that it does not generate classes at runtime or load them via non-built-in class loaders.\n  2) If the classes must be generated, try to generate them at build time in a static initializer of a dedicated class. The generated java.lang.Class objects should be stored in static fields and the dedicated class initialized by passing '--initialize-at-build-time=<class_name>' as the build argument.\n  3) If none of the above is applicable, use the tracing agent to run this application and collect predefined classes with 'java -agentlib:native-image-agent=config-output-dir=<config-dir>,experimental-class-define-support <application-arguments>'. Note that this is an experimental feature and that it does not guarantee success. Furthermore, the resulting classes can contain entries from the classpath that should be manually filtered out to reduce image size. The agent should be used only in cases where modifying the source of the project is not possible.\n".replace("\n", System.lineSeparator());

    @Fold
    public static boolean isSupported() {
        return Options.RuntimeClassLoading.getValue();
    }

    public static boolean followReflectionConfiguration() {
        return ((ClassLoadingSupport)ImageSingletons.lookup(ClassLoadingSupport.class)).followReflectionConfiguration();
    }

    public static Class<?> defineClass(ClassLoader loader, String expectedName, byte[] b, int off, int len, ClassDefinitionInfo info) {
        if (PredefinedClassesSupport.hasBytecodeClasses()) {
            Class<?> knownClass = PredefinedClassesSupport.knownClass(b, off, len);
            if (knownClass != null) {
                String dotName;
                if (expectedName != null && !(dotName = expectedName.replace('/', '.')).equals(knownClass.getName())) {
                    throw new NoClassDefFoundError(knownClass.getName() + " (wrong name: " + dotName + ")");
                }
                PredefinedClassesSupport.loadClass(loader, info.protectionDomain, knownClass);
                return knownClass;
            }
            String name = expectedName != null ? expectedName : "(name not specified)";
            throw VMError.unsupportedFeature("Class " + name + " with hash " + PredefinedClassesSupport.getHash(b, off, len) + " was not provided during the image build via the 'predefined-classes-config.json' file. Please see 'BuildConfiguration.md'.");
        }
        if (RuntimeClassLoading.isSupported()) {
            return ClassRegistries.defineClass(loader, expectedName, b, off, len, info);
        }
        throw RuntimeClassLoading.throwNoBytecodeClasses(expectedName);
    }

    public static RuntimeException throwNoBytecodeClasses(String className) {
        assert (!PredefinedClassesSupport.hasBytecodeClasses() && !RuntimeClassLoading.isSupported());
        throw VMError.unsupportedFeature("Classes cannot be defined at runtime by default when using ahead-of-time Native Image compilation. Tried to define class '" + className + "'" + System.lineSeparator() + DEFINITION_NOT_SUPPORTED_MESSAGE);
    }

    public static DynamicHub getOrCreateArrayHub(DynamicHub hub) {
        if (hub.getArrayHub() == null) {
            VMError.guarantee(RuntimeClassLoading.isSupported());
            throw VMError.unimplemented("array hub creation");
        }
        return hub.getArrayHub();
    }

    public static ResolvedJavaType createInterpreterType(DynamicHub hub, ResolvedJavaType analysisType) {
        return ((CremaSupport)ImageSingletons.lookup(CremaSupport.class)).createInterpreterType(hub, analysisType);
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> RuntimeClassLoading = new HostedOptionKey<Boolean>(Boolean.valueOf(false), Options::validateRuntimeClassLoading){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                if (newValue.booleanValue()) {
                    SubstrateOptions.ClosedTypeWorld.update(values, false);
                    ClassForNameSupport.Options.ClassForNameRespectsClassLoader.update(values, true);
                    PredefinedClassesSupport.Options.SupportPredefinedClasses.update(values, false);
                }
            }
        };
        public static final HostedOptionKey<VerifyMode> ClassVerification = new HostedOptionKey<VerifyMode>(VerifyMode.REMOTE);

        private static void validateRuntimeClassLoading(HostedOptionKey<Boolean> optionKey) {
            if (!optionKey.getValue().booleanValue()) {
                return;
            }
            if (SubstrateOptions.ClosedTypeWorld.getValue().booleanValue()) {
                throw UserError.invalidOptionValue(RuntimeClassLoading, RuntimeClassLoading.getValue(), "Requires an open type world, Please use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.ClosedTypeWorld, "-"));
            }
            if (!ClassForNameSupport.Options.ClassForNameRespectsClassLoader.getValue().booleanValue()) {
                throw UserError.invalidOptionValue(RuntimeClassLoading, RuntimeClassLoading.getValue(), "Requires Class.forName to respect the classloader argument, Please use " + SubstrateOptionsParser.commandArgument(ClassForNameSupport.Options.ClassForNameRespectsClassLoader, "+"));
            }
            if (PredefinedClassesSupport.Options.SupportPredefinedClasses.getValue().booleanValue()) {
                throw UserError.invalidOptionValue(RuntimeClassLoading, RuntimeClassLoading.getValue(), "Requires predefined class support to be disabled, Please use " + SubstrateOptionsParser.commandArgument(PredefinedClassesSupport.Options.SupportPredefinedClasses, "-"));
            }
        }
    }

    public static final class ClassDefinitionInfo {
        public static final ClassDefinitionInfo EMPTY = new ClassDefinitionInfo(null, null, null, false, false, false);
        public final ProtectionDomain protectionDomain;
        public final Class<?> dynamicNest;
        public final Object classData;
        public final boolean isHidden;
        public final boolean isStrongHidden;
        public final boolean forceAllowVMAnnotations;

        public ClassDefinitionInfo(ProtectionDomain protectionDomain) {
            this(protectionDomain, null, null, false, false, false);
        }

        public ClassDefinitionInfo(ProtectionDomain protectionDomain, Class<?> dynamicNest, Object classData, boolean isStrongHidden, boolean forceAllowVMAnnotations) {
            this(protectionDomain, dynamicNest, classData, true, isStrongHidden, forceAllowVMAnnotations);
        }

        private ClassDefinitionInfo(ProtectionDomain protectionDomain, Class<?> dynamicNest, Object classData, boolean isHidden, boolean isStrongHidden, boolean forceAllowVMAnnotations) {
            assert (!isStrongHidden || isHidden);
            assert (dynamicNest == null || isHidden);
            assert (classData == null || isHidden);
            assert (!forceAllowVMAnnotations || isHidden);
            this.protectionDomain = protectionDomain;
            this.dynamicNest = dynamicNest;
            this.classData = classData;
            this.isHidden = isHidden;
            this.isStrongHidden = isStrongHidden;
            this.forceAllowVMAnnotations = forceAllowVMAnnotations;
        }

        public boolean addedToRegistry() {
            return !this.isHidden();
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public boolean isStrongHidden() {
            return this.isStrongHidden;
        }

        public boolean forceAllowVMAnnotations() {
            return this.forceAllowVMAnnotations;
        }

        public int patchFlags(int classFlags) {
            int flags = classFlags;
            if (this.isHidden()) {
                flags |= 0x4000000;
            }
            return flags;
        }

        public String toString() {
            if (this == EMPTY) {
                return "EMPTY";
            }
            if (!this.isHidden) {
                return "ClassDefinitionInfo{protectionDomain=" + String.valueOf(this.protectionDomain) + "}";
            }
            return "ClassDefinitionInfo{protectionDomain=" + String.valueOf(this.protectionDomain) + ", dynamicNest=" + String.valueOf(this.dynamicNest) + ", classData=" + String.valueOf(this.classData) + ", isHidden=" + this.isHidden + ", isStrongHidden=" + this.isStrongHidden + ", forceAllowVMAnnotations=" + this.forceAllowVMAnnotations + "}";
        }
    }

    public static enum VerifyMode {
        NONE,
        REMOTE,
        ALL;


        public boolean needsVerification(ClassLoader loader) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1 -> {
                    if (loader != null) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> true;
            };
        }
    }
}

