/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.hub.registry.AbstractRuntimeClassRegistry;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import java.util.Objects;
import jdk.internal.loader.ClassLoaders;

public final class UserDefinedClassRegistry
extends AbstractRuntimeClassRegistry {
    private final ClassLoader loader;
    private final boolean isPlatform;

    UserDefinedClassRegistry(ClassLoader loader) {
        this.loader = Objects.requireNonNull(loader);
        this.isPlatform = loader == ClassLoaders.platformClassLoader();
    }

    @Override
    public Class<?> doLoadClass(Symbol<Type> type) throws ClassNotFoundException {
        assert (type.byteAt(0) == 76 && type.byteAt(type.length() - 1) == 59) : type;
        String name = type.subSequence(1, type.length() - 1).toString().replace('/', '.');
        return this.loader.loadClass(name);
    }

    @Override
    protected boolean loaderIsBootOrPlatform() {
        return this.isPlatform;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

