/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.graalvm.nativeimage.ImageInfo;

public class ResourcesHelper {
    public static URL nameToResourceURL(String resourceName) {
        return Resources.createURL(resourceName);
    }

    public static URL nameToResourceURL(Module module, String resourceName) {
        return Resources.createURL(module, resourceName);
    }

    public static InputStream nameToResourceInputStream(String mn, String resourceName) throws IOException {
        VMError.guarantee(ImageInfo.inImageRuntimeCode(), "ResourcesHelper code should only be used at runtime");
        Module module = mn == null ? null : (Module)ModuleLayer.boot().findModule(mn).orElse(null);
        URL url = ResourcesHelper.nameToResourceURL(module, resourceName);
        return url != null ? url.openStream() : null;
    }

    public static List<URL> nameToResourceListURLs(String resourcesName) {
        Enumeration<URL> urls = Resources.createURLs(resourcesName);
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            resourceURLs.add(urls.nextElement());
        }
        return resourceURLs;
    }

    public static Enumeration<URL> nameToResourceEnumerationURLs(String resourcesName) {
        return Collections.enumeration(ResourcesHelper.nameToResourceListURLs(resourcesName));
    }
}

