/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.SuppressFBWarnings;

public class JfrArgumentParser {
    public static Map<JfrArgument, String> parseJfrOptions(RuntimeOptionKey<String> runtimeOptionKey, JfrArgument[] possibleArguments) throws JfrArgumentParsingFailed {
        String userInput = runtimeOptionKey.getValue();
        if (!userInput.isEmpty()) {
            String[] options = StringUtil.split((String)userInput, (String)",");
            return JfrArgumentParser.parseJfrOptions(options, possibleArguments);
        }
        return new HashMap<JfrArgument, String>();
    }

    private static Map<JfrArgument, String> parseJfrOptions(String[] options, JfrArgument[] possibleArguments) throws JfrArgumentParsingFailed {
        HashMap<JfrArgument, String> optionsMap = new HashMap<JfrArgument, String>();
        for (String option : options) {
            String[] keyVal = StringUtil.split((String)option, (String)"=");
            if (keyVal.length != 2) {
                throw new JfrArgumentParsingFailed("Invalid argument '" + keyVal[0] + "' in JFR options");
            }
            JfrArgument arg = JfrArgumentParser.findArgument(possibleArguments, keyVal[0]);
            if (arg == null) {
                throw new JfrArgumentParsingFailed("Unknown argument '" + keyVal[0] + "' in JFR options");
            }
            optionsMap.put(arg, keyVal[1]);
        }
        return optionsMap;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="null allowed as return value")
    public static Boolean parseBoolean(Map<JfrArgument, String> args, JfrArgument key) throws JfrArgumentParsingFailed {
        String value = args.get(key);
        if (value == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new JfrArgumentParsingFailed("Could not parse JFR argument '" + key.getCmdLineKey() + "=" + value + "'. Expected a boolean value.");
    }

    public static Integer parseInteger(Map<JfrArgument, String> args, JfrArgument key) throws JfrArgumentParsingFailed {
        String value = args.get(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Throwable e) {
                throw new JfrArgumentParsingFailed("Could not parse JFR argument '" + key.getCmdLineKey() + "=" + value + "'. " + e.getMessage());
            }
        }
        return null;
    }

    public static Long parseMaxSize(Map<JfrArgument, String> args, JfrArgument key) throws JfrArgumentParsingFailed {
        String value = args.get(key);
        if (value == null) {
            return null;
        }
        try {
            long number;
            int idx = JfrArgumentParser.indexOfFirstNonDigitCharacter(value);
            try {
                number = Long.parseLong(value.substring(0, idx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected a positive number.");
            }
            if (idx == value.length()) {
                return number;
            }
            char unit = value.substring(idx).charAt(0);
            return switch (unit) {
                case 'K', 'k' -> number * 1024L;
                case 'M', 'm' -> number * 1024L * 1024L;
                case 'G', 'g' -> number * 1024L * 1024L * 1024L;
                default -> number;
            };
        }
        catch (IllegalArgumentException e) {
            throw new JfrArgumentParsingFailed("Could not parse JFR argument '" + key.getCmdLineKey() + "=" + value + "'. " + e.getMessage());
        }
    }

    private static int indexOfFirstNonDigitCharacter(String durationText) {
        int idx;
        for (idx = 0; idx < durationText.length() && Character.isDigit(durationText.charAt(idx)); ++idx) {
        }
        return idx;
    }

    private static JfrArgument findArgument(JfrArgument[] possibleArguments, String value) {
        for (JfrArgument arg : possibleArguments) {
            if (!arg.getCmdLineKey().equals(value)) continue;
            return arg;
        }
        return null;
    }

    public static interface JfrArgument {
        public String getCmdLineKey();
    }

    public static class JfrArgumentParsingFailed
    extends RuntimeException {
        private static final long serialVersionUID = -1050173145647068124L;

        JfrArgumentParsingFailed(String message, Throwable cause) {
            super(message, cause);
        }

        JfrArgumentParsingFailed(String message) {
            super(message);
        }
    }

    public static enum FlightRecorderOptionsArgument implements JfrArgument
    {
        GlobalBufferSize("globalbuffersize"),
        MaxChunkSize("maxchunksize"),
        MemorySize("memorysize"),
        OldObjectQueueSize("old-object-queue-size"),
        RepositoryPath("repository"),
        StackDepth("stackdepth"),
        ThreadBufferSize("threadbuffersize"),
        PreserveRepository("preserve-repository");

        private final String cmdLineKey;

        private FlightRecorderOptionsArgument(String key) {
            this.cmdLineKey = key;
        }

        @Override
        public String getCmdLineKey() {
            return this.cmdLineKey;
        }
    }
}

