/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.thread.VMOperation;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class ChunkBasedCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    protected static final OutOfMemoryError ALIGNED_CHUNK_COMMIT_FAILED = new OutOfMemoryError("Could not commit an aligned heap chunk. Either the OS/container is out of memory or another system-level resource limit was reached (such as the number of memory mappings).");
    protected static final OutOfMemoryError UNALIGNED_CHUNK_COMMIT_FAILED = new OutOfMemoryError("Could not commit an unaligned heap chunk. Either the OS/container is out of memory or another system-level resource limit was reached (such as the number of memory mappings).");

    @Fold
    public static ChunkBasedCommittedMemoryProvider get() {
        return (ChunkBasedCommittedMemoryProvider)ImageSingletons.lookup(CommittedMemoryProvider.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord nbytes, UnsignedWord alignment) {
        Pointer result = this.allocate(nbytes, alignment, false, NmtCategory.JavaHeap);
        if (result.isNull()) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(ALIGNED_CHUNK_COMMIT_FAILED);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateUnalignedChunk(UnsignedWord nbytes) {
        Pointer result = this.allocate(nbytes, ChunkBasedCommittedMemoryProvider.getAlignmentForUnalignedChunks(), false, NmtCategory.JavaHeap);
        if (result.isNull()) {
            throw OutOfMemoryUtil.reportOutOfMemoryError(UNALIGNED_CHUNK_COMMIT_FAILED);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean areUnalignedChunksZeroed() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        ChunkBasedCommittedMemoryProvider.free(start, nbytes, NmtCategory.JavaHeap);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase start, UnsignedWord nbytes) {
        ChunkBasedCommittedMemoryProvider.free(start, nbytes, NmtCategory.JavaHeap);
    }

    @Fold
    protected static UnsignedWord getAlignmentForUnalignedChunks() {
        int alignment = Math.max(ConfigurationValues.getTarget().wordSize, ConfigurationValues.getObjectLayout().getAlignment());
        return Word.unsigned((int)alignment);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void beforeGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void afterGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void uncommitUnusedMemory() {
        assert (VMOperation.isGCInProgress()) : "may only be called by the GC";
    }
}

