/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.container.Container;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.UnsignedWord;

public class LinuxPhysicalMemorySupportImpl
implements PhysicalMemory.PhysicalMemorySupport {
    private static final long K = 1024L;

    @Override
    public UnsignedWord size() {
        long numberOfPhysicalMemoryPages = Unistd.sysconf(Unistd._SC_PHYS_PAGES());
        long sizeOfAPhysicalMemoryPage = Unistd.sysconf(Unistd._SC_PAGESIZE());
        if (numberOfPhysicalMemoryPages == -1L || sizeOfAPhysicalMemoryPage == -1L) {
            throw VMError.shouldNotReachHere("Physical memory size (number of pages or page size) not available");
        }
        return Word.unsigned((long)numberOfPhysicalMemoryPages).multiply(Word.unsigned((long)sizeOfAPhysicalMemoryPage));
    }

    @Override
    public long usedSize() {
        assert (!Container.singleton().isContainerized() || Container.singleton().getCachedMemoryLimitInBytes() <= 0L) : "Should be using OperatingSystemMXBean";
        return LinuxPhysicalMemorySupportImpl.getUsedSizeFromProcMemInfo();
    }

    private static long getUsedSizeFromProcMemInfo() {
        try {
            List<String> lines = LinuxPhysicalMemorySupportImpl.readAllLines("/proc/meminfo");
            for (String line : lines) {
                if (!line.contains("MemAvailable")) continue;
                return PhysicalMemory.size().rawValue() - LinuxPhysicalMemorySupportImpl.parseFirstNumber(line) * 1024L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static List<String> readAllLines(String fileName) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName, StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static long parseFirstNumber(String str) {
        int firstDigit = -1;
        int lastDigit = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) {
                if (firstDigit == -1) {
                    firstDigit = i;
                }
                lastDigit = i;
                continue;
            }
            if (firstDigit != -1) break;
        }
        if (firstDigit >= 0) {
            String number = str.substring(firstDigit, lastDigit + 1);
            return Long.parseLong(number);
        }
        return -1L;
    }
}

