/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VirtualThreadHelper;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@TargetClass(className="java.lang.VirtualThread")
public final class Target_java_lang_VirtualThread {
    @Alias
    static int NEW;
    @Alias
    static int STARTED;
    @Alias
    static int RUNNING;
    @Alias
    static int PARKING;
    @Alias
    static int PARKED;
    @Alias
    static int PINNED;
    @Alias
    static int YIELDING;
    @Alias
    static int YIELDED;
    @Alias
    static int TERMINATED;
    @Alias
    static int SUSPENDED;
    @Alias
    static int TIMED_PARKING;
    @Alias
    static int TIMED_PARKED;
    @Alias
    static int TIMED_PINNED;
    @Alias
    static int UNPARKED;
    @Alias
    static int BLOCKING;
    @Alias
    static int BLOCKED;
    @Alias
    static int UNBLOCKED;
    @Alias
    static int WAITING;
    @Alias
    static int WAIT;
    @Alias
    static int TIMED_WAITING;
    @Alias
    static int TIMED_WAIT;
    @Alias
    static Target_jdk_internal_vm_ContinuationScope VTHREAD_SCOPE;
    @Alias
    @InjectAccessors(value=DefaultSchedulerAccessor.class)
    public static ForkJoinPool DEFAULT_SCHEDULER;
    @Alias
    @InjectAccessors(value=SchedulerAccessor.class)
    public Executor scheduler;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=NondefaultSchedulerSupplier.class)
    private Executor nondefaultScheduler;
    @Alias
    volatile int state;
    @Delete
    volatile Target_java_lang_VirtualThread next;
    @Alias
    @InjectAccessors(value=AlwaysFalseAccessor.class)
    boolean blockPermit;
    @Alias
    @InjectAccessors(value=AlwaysFalseAccessor.class)
    boolean onWaitingList;
    @Alias
    @InjectAccessors(value=AlwaysFalseAccessor.class)
    boolean notified;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public long jfrEpochId;
    @Alias
    volatile Thread carrierThread;
    @Alias
    volatile Target_sun_nio_ch_Interruptible nioBlocker;
    @Alias
    volatile boolean interrupted;

    @Alias
    private static native ForkJoinPool createDefaultScheduler();

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    private void notifyJvmtiStart() {
    }

    @Substitute
    private void notifyJvmtiEnd() {
    }

    @Substitute
    private void notifyJvmtiMount(boolean hide) {
    }

    @Substitute
    private void notifyJvmtiUnmount(boolean hide) {
    }

    @Substitute
    private static void notifyJvmtiDisableSuspend(boolean enter) {
    }

    @Substitute
    private static void postPinnedEvent(String op) {
    }

    @Alias
    public static native Target_jdk_internal_vm_ContinuationScope continuationScope();

    @Delete
    native StackTraceElement[] asyncGetStackTrace();

    @Alias
    native StackTraceElement[] tryGetStackTrace();

    @Alias
    native void disableSuspendAndPreempt();

    @Alias
    native void enableSuspendAndPreempt();

    @Alias
    native Object carrierThreadAccessLock();

    @Alias
    private native void setCarrierThread(Target_java_lang_Thread var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    void mount() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(Target_java_lang_Thread.currentCarrierThread());
        this.setCarrierThread(carrier);
        if (this.interrupted) {
            carrier.setInterrupt();
        } else if (carrier.isInterrupted()) {
            Object object = VirtualThreadHelper.asTarget((Object)this).interruptLock;
            synchronized (object) {
                if (!this.interrupted) {
                    carrier.clearInterrupt();
                }
            }
        }
        carrier.setCurrentThread(VirtualThreadHelper.asThread(this));
        if (HasJfrSupport.get()) {
            SubstrateJVM.getThreadRepo().registerThread(VirtualThreadHelper.asThread(this));
        }
    }

    @Alias
    native int state();

    @Substitute
    void setState(int s) {
        assert (s != BLOCKING && s != BLOCKED && s != UNBLOCKED && s != WAITING && s != WAIT && s != TIMED_WAIT && s != TIMED_WAITING) : "states should never be reached with our monitor implementation";
        this.state = s;
    }

    @Substitute
    void waitTimeoutExpired(byte seqNo) {
        throw VMError.shouldNotReachHere("not used in our monitor implementation");
    }

    @Delete
    static native void unblockVirtualThreads();

    @Delete
    private static native Target_java_lang_VirtualThread takeVirtualThreadListToUnblock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    Thread.State threadState() {
        int state = this.state() & ~SUSPENDED;
        if (state == NEW) {
            return Thread.State.NEW;
        }
        if (state == STARTED) {
            if (VirtualThreadHelper.asTarget(this).threadContainer() == null) {
                return Thread.State.NEW;
            }
            return Thread.State.RUNNABLE;
        }
        if (state == UNPARKED || state == YIELDED) {
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNING) {
            if (Thread.currentThread() != VirtualThreadHelper.asThread(this)) {
                this.disableSuspendAndPreempt();
                try {
                    Object object = this.carrierThreadAccessLock();
                    synchronized (object) {
                        block23: {
                            Thread carrier = this.carrierThread;
                            if (carrier == null) break block23;
                            Thread.State state2 = VirtualThreadHelper.asTarget(carrier).threadState();
                            return state2;
                        }
                    }
                }
                finally {
                    this.enableSuspendAndPreempt();
                }
            }
            return Thread.State.RUNNABLE;
        }
        if (state == PARKING || state == YIELDING) {
            return Thread.State.RUNNABLE;
        }
        if (state == PARKED || state == PINNED || state == TIMED_PARKED || state == TIMED_PINNED) {
            boolean timed = state == TIMED_PARKED || state == TIMED_PINNED;
            int parkedThreadStatus = MonitorSupport.singleton().getParkedThreadStatus(VirtualThreadHelper.asThread(this), timed);
            switch (parkedThreadStatus) {
                case 1025: {
                    return Thread.State.BLOCKED;
                }
                case 401: 
                case 657: {
                    return Thread.State.WAITING;
                }
                case 417: 
                case 673: {
                    return Thread.State.TIMED_WAITING;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(parkedThreadStatus);
        }
        if (state == TERMINATED) {
            return Thread.State.TERMINATED;
        }
        if (state == TIMED_PARKING) {
            return Thread.State.RUNNABLE;
        }
        throw new InternalError();
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    native boolean isTerminated();

    private static final class NondefaultSchedulerSupplier
    implements FieldValueTransformer {
        private NondefaultSchedulerSupplier() {
        }

        public Object transform(Object receiver, Object originalValue) {
            Class vthreadClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.VirtualThread");
            Object defaultScheduler = ReflectionUtil.readStaticField((Class)vthreadClass, (String)"DEFAULT_SCHEDULER");
            return originalValue == defaultScheduler ? null : originalValue;
        }
    }

    private static final class SchedulerAccessor {
        private SchedulerAccessor() {
        }

        static Executor get(Target_java_lang_VirtualThread self) {
            Executor scheduler = self.nondefaultScheduler;
            if (scheduler == null) {
                scheduler = DefaultSchedulerAccessor.get();
            }
            return scheduler;
        }

        static void set(Target_java_lang_VirtualThread self, Executor executor) {
            assert (self.nondefaultScheduler == null);
            if (executor != DefaultSchedulerAccessor.get()) {
                self.nondefaultScheduler = executor;
            }
        }
    }

    private static final class DefaultSchedulerAccessor {
        private static volatile ForkJoinPool defaultScheduler;

        private DefaultSchedulerAccessor() {
        }

        public static ForkJoinPool get() {
            ForkJoinPool result = defaultScheduler;
            if (result == null) {
                result = DefaultSchedulerAccessor.initializeDefaultScheduler();
            }
            return result;
        }

        private static synchronized ForkJoinPool initializeDefaultScheduler() {
            ForkJoinPool result = defaultScheduler;
            if (result == null) {
                defaultScheduler = result = Target_java_lang_VirtualThread.createDefaultScheduler();
            }
            return result;
        }
    }

    private static final class AlwaysFalseAccessor {
        private AlwaysFalseAccessor() {
        }

        static boolean get(Target_java_lang_VirtualThread vt) {
            return false;
        }

        static void set(Target_java_lang_VirtualThread vt, boolean value) {
            assert (!value);
        }
    }
}

