/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.meta.ObjectConstantEquality;
import com.oracle.svm.graal.isolated.IsolateAwareObjectConstantEquality;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class IsolateAwareObjectConstantEqualityFeature
implements InternalFeature {
    IsolateAwareObjectConstantEqualityFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.supportCompileInIsolates();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (RuntimeCompilation.isEnabled()) {
            ImageSingletons.add(ObjectConstantEquality.class, (Object)new IsolateAwareObjectConstantEquality());
        }
    }
}

