/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.TrackDynamicAccessEnabled;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.driver.IncludeOptionsSupport;
import com.oracle.svm.hosted.phases.DynamicAccessDetectionPhase;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class DynamicAccessDetectionFeature
implements InternalFeature {
    private static final Set<String> neverInlineMethods = Set.of("java.lang.invoke.MethodHandles$Lookup.unreflectGetter", "java.lang.invoke.MethodHandles$Lookup.unreflectSetter", "java.io.ObjectInputStream.readObject", "java.io.ObjectStreamClass.lookup", "java.lang.reflect.Array.newInstance", "java.lang.ClassLoader.loadClass", "java.lang.foreign.Linker.nativeLinker");
    public static final String TRACK_ALL = "all";
    private static final String OUTPUT_DIR_NAME = "dynamic-access";
    private static final String TRACK_NONE = "none";
    private static final String TO_CONSOLE = "to-console";
    private static final String NO_DUMP = "no-dump";
    private EconomicSet<String> sourceEntries;
    private final Map<String, MethodsByAccessKind> callsBySourceEntry;
    private final Set<FoldEntry> foldEntries = ConcurrentHashMap.newKeySet();
    private final BuildArtifacts buildArtifacts = BuildArtifacts.singleton();
    private final OptionValues hostedOptionValues = HostedOptionValues.singleton();
    private boolean printToConsole;
    private boolean dumpJsonFiles = true;

    public DynamicAccessDetectionFeature() {
        this.callsBySourceEntry = new ConcurrentSkipListMap<String, MethodsByAccessKind>();
    }

    public static DynamicAccessDetectionFeature instance() {
        return (DynamicAccessDetectionFeature)ImageSingletons.lookup(DynamicAccessDetectionFeature.class);
    }

    public void addCall(String entry, DynamicAccessDetectionPhase.DynamicAccessKind accessKind, String call, String callLocation) {
        MethodsByAccessKind entryContent = this.callsBySourceEntry.computeIfAbsent(entry, k -> new MethodsByAccessKind());
        CallLocationsByMethod methodCallLocations = entryContent.methodsByAccessKind().computeIfAbsent(accessKind, k -> new CallLocationsByMethod());
        ConcurrentLinkedQueue callLocations = methodCallLocations.callLocationsByMethod().computeIfAbsent(call, k -> new ConcurrentLinkedQueue());
        callLocations.add(callLocation);
    }

    public MethodsByAccessKind getMethodsByAccessKind(String entry) {
        return this.callsBySourceEntry.computeIfAbsent(entry, k -> new MethodsByAccessKind());
    }

    public EconomicSet<String> getSourceEntries() {
        return this.sourceEntries;
    }

    public static String getEntryName(String path) {
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1);
        if (fileName.endsWith(".jar")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    private void printReportForEntry(String entry) {
        System.out.println("Dynamic method usage detected in " + entry + ":");
        MethodsByAccessKind methodsByAccessKind = this.getMethodsByAccessKind(entry);
        for (DynamicAccessDetectionPhase.DynamicAccessKind accessKind : methodsByAccessKind.getAccessKinds()) {
            System.out.println("    " + String.valueOf((Object)accessKind) + " calls detected:");
            CallLocationsByMethod methodCallLocations = methodsByAccessKind.getCallLocationsByMethod(accessKind);
            for (String call : methodCallLocations.getMethods()) {
                System.out.println("        " + call + ":");
                for (String callLocation : methodCallLocations.getMethodCallLocations(call)) {
                    System.out.println("            at " + callLocation);
                }
            }
        }
    }

    private static Path getOrCreateDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new NoSuchFileException(directory.toString(), null, "Failed to retrieve directory: The path exists but is not a directory.");
            }
        } else {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Failed to create directory: " + String.valueOf(directory), e);
            }
        }
        return directory;
    }

    private void dumpReportForEntry(String entry) {
        try {
            MethodsByAccessKind methodsByAccessKind = this.getMethodsByAccessKind(entry);
            Path reportDirectory = NativeImageGenerator.generatedFiles(this.hostedOptionValues).resolve(OUTPUT_DIR_NAME);
            for (DynamicAccessDetectionPhase.DynamicAccessKind accessKind : methodsByAccessKind.getAccessKinds()) {
                Path entryDirectory = DynamicAccessDetectionFeature.getOrCreateDirectory(reportDirectory.resolve(DynamicAccessDetectionFeature.getEntryName(entry)));
                Path targetPath = entryDirectory.resolve(accessKind.fileName);
                ReportUtils.report((String)"Dynamic Access Detection Report", (Path)targetPath, writer -> DynamicAccessDetectionFeature.generateDynamicAccessReport(writer, accessKind, methodsByAccessKind), (boolean)false);
                this.buildArtifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, targetPath);
            }
        }
        catch (IOException e) {
            throw UserError.abort("Failed to dump report for entry %s: %s", entry, e.getMessage());
        }
    }

    private static void generateDynamicAccessReport(PrintWriter writer, DynamicAccessDetectionPhase.DynamicAccessKind accessKind, MethodsByAccessKind methodsByAccessKind) {
        writer.println("{");
        String methodsJson = methodsByAccessKind.getCallLocationsByMethod(accessKind).getMethods().stream().map(methodName -> DynamicAccessDetectionFeature.toMethodJson(accessKind, methodName, methodsByAccessKind)).collect(Collectors.joining("," + System.lineSeparator()));
        writer.println(methodsJson);
        writer.println("}");
    }

    private static String toMethodJson(DynamicAccessDetectionPhase.DynamicAccessKind accessKind, String methodName, MethodsByAccessKind methodsByAccessKind) {
        String locationsJson = methodsByAccessKind.getCallLocationsByMethod(accessKind).getMethodCallLocations(methodName).stream().map(location -> "    \"" + location + "\"").collect(Collectors.joining("," + System.lineSeparator()));
        return "  \"" + methodName + "\": [" + System.lineSeparator() + locationsJson + System.lineSeparator() + "  ]";
    }

    public void reportDynamicAccess() {
        for (String entry : this.sourceEntries) {
            if (!this.callsBySourceEntry.containsKey(entry)) continue;
            if (this.dumpJsonFiles) {
                this.dumpReportForEntry(entry);
            }
            if (!this.printToConsole) continue;
            this.printReportForEntry(entry);
        }
    }

    public void addFoldEntry(int bci, ResolvedJavaMethod method) {
        this.foldEntries.add(new FoldEntry(bci, method));
    }

    public boolean containsFoldEntry(int bci, ResolvedJavaMethod method) {
        return this.foldEntries.contains(new FoldEntry(bci, method));
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageClassLoader imageClassLoader = ((FeatureImpl.AfterRegistrationAccessImpl)access).getImageClassLoader();
        NativeImageClassLoaderSupport support = imageClassLoader.classLoaderSupport;
        NativeImageClassLoaderSupport.IncludeSelectors dynamicAccessSelectors = support.getDynamicAccessSelectors();
        EconomicSet tmpSet = EconomicSet.create();
        tmpSet.addAll((Iterable)dynamicAccessSelectors.classpathEntries().stream().map(path -> path.toAbsolutePath().toString()).collect(Collectors.toSet()));
        tmpSet.addAll(dynamicAccessSelectors.moduleNames());
        tmpSet.addAll((Iterable)dynamicAccessSelectors.packages().stream().map(Object::toString).collect(Collectors.toSet()));
        this.sourceEntries = EconomicSet.create((UnmodifiableEconomicSet)tmpSet);
        AccumulatingLocatableMultiOptionValue.Strings options = SubstrateOptions.TrackDynamicAccess.getValue();
        Iterator iterator = options.values().iterator();
        while (iterator.hasNext()) {
            String optionValue;
            switch (optionValue = (String)iterator.next()) {
                case "to-console": {
                    this.printToConsole = true;
                    break;
                }
                case "no-dump": {
                    this.dumpJsonFiles = false;
                    break;
                }
                case "none": {
                    this.printToConsole = false;
                    this.dumpJsonFiles = true;
                }
            }
        }
        ImageSingletons.add(TrackDynamicAccessEnabled.TrackDynamicAccessEnabledSingleton.class, (Object)new TrackDynamicAccessEnabled.TrackDynamicAccessEnabledSingleton(this){});
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        DynamicAccessDetectionFeature.instance().reportDynamicAccess();
        DynamicAccessDetectionPhase.clearMethodSignatures();
        this.foldEntries.clear();
    }

    public void beforeHeapLayout(Feature.BeforeHeapLayoutAccess access) {
        this.callsBySourceEntry.clear();
        this.sourceEntries.clear();
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        ImageClassLoader imageClassLoader = ((FeatureImpl.IsInConfigurationAccessImpl)access).getImageClassLoader();
        NativeImageClassLoaderSupport support = imageClassLoader.classLoaderSupport;
        return !support.dynamicAccessSelectorsEmpty();
    }

    private static String dynamicAccessPossibleOptions() {
        return String.format("[%s, %s, %s, %s, %s]", TRACK_ALL, TRACK_NONE, TO_CONSOLE, NO_DUMP, IncludeOptionsSupport.possibleExtendedOptions());
    }

    public static void parseDynamicAccessOptions(EconomicMap<OptionKey<?>, Object> hostedValues, NativeImageClassLoaderSupport classLoaderSupport) {
        AccumulatingLocatableMultiOptionValue.Strings trackDynamicAccess = (AccumulatingLocatableMultiOptionValue.Strings)SubstrateOptions.TrackDynamicAccess.getValue(new OptionValues(hostedValues));
        Stream<LocatableMultiOptionValue.ValueWithOrigin<LocatableMultiOptionValue.ValueWithOrigin>> valuesWithOrigins = trackDynamicAccess.getValuesWithOrigins();
        valuesWithOrigins.forEach(valueWithOrigin -> {
            String optionArgument = SubstrateOptionsParser.commandArgument(SubstrateOptions.TrackDynamicAccess, (String)valueWithOrigin.value(), true, false);
            List<String> options = Arrays.stream(((String)valueWithOrigin.value()).split(",")).toList();
            block11: for (String option : options) {
                UserError.guarantee(!option.isEmpty(), "Option %s from %s cannot be passed an empty string", optionArgument, valueWithOrigin.origin());
                switch (option) {
                    case "all": {
                        classLoaderSupport.setTrackAllDynamicAccess((LocatableMultiOptionValue.ValueWithOrigin<String>)valueWithOrigin);
                        continue block11;
                    }
                    case "none": {
                        classLoaderSupport.clearDynamicAccessSelectors();
                        continue block11;
                    }
                    case "to-console": 
                    case "no-dump": {
                        continue block11;
                    }
                }
                IncludeOptionsSupport.parseIncludeSelector(optionArgument, valueWithOrigin, classLoaderSupport.getDynamicAccessSelectors(), IncludeOptionsSupport.ExtendedOption.parse(option), DynamicAccessDetectionFeature.dynamicAccessPossibleOptions());
            }
        });
        if (!classLoaderSupport.dynamicAccessSelectorsEmpty()) {
            for (String method : neverInlineMethods) {
                SubstrateOptions.NeverInline.update(hostedValues, method);
            }
        }
    }

    public record MethodsByAccessKind(Map<DynamicAccessDetectionPhase.DynamicAccessKind, CallLocationsByMethod> methodsByAccessKind) {
        MethodsByAccessKind() {
            this(new ConcurrentSkipListMap<DynamicAccessDetectionPhase.DynamicAccessKind, CallLocationsByMethod>());
        }

        public Set<DynamicAccessDetectionPhase.DynamicAccessKind> getAccessKinds() {
            return this.methodsByAccessKind.keySet();
        }

        public CallLocationsByMethod getCallLocationsByMethod(DynamicAccessDetectionPhase.DynamicAccessKind accessKind) {
            return this.methodsByAccessKind.getOrDefault((Object)accessKind, new CallLocationsByMethod());
        }
    }

    public record CallLocationsByMethod(Map<String, ConcurrentLinkedQueue<String>> callLocationsByMethod) {
        CallLocationsByMethod() {
            this(new ConcurrentSkipListMap<String, ConcurrentLinkedQueue<String>>());
        }

        public Set<String> getMethods() {
            return this.callLocationsByMethod.keySet();
        }

        public ConcurrentLinkedQueue<String> getMethodCallLocations(String methodName) {
            return this.callLocationsByMethod.getOrDefault(methodName, new ConcurrentLinkedQueue());
        }
    }

    public static class FoldEntry {
        private final int bci;
        private final ResolvedJavaMethod method;

        public FoldEntry(int bci, ResolvedJavaMethod method) {
            this.bci = bci;
            this.method = method;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FoldEntry other = (FoldEntry)obj;
            return this.bci == other.bci && Objects.equals(this.method, other.method);
        }

        public int hashCode() {
            return Objects.hash(this.bci, this.method);
        }
    }
}

