/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ObjectTreePrinter;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaMethod;

public final class ReachabilityTracePrinter {
    public static final String PATH_MESSAGE_PREFIX = "See the generated report for a complete reachability trace: ";

    private static String reportElements(String element, String trace, String reportsPath, String baseImageName, List<String> patterns, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> option) {
        String elements = element + "s";
        Path path = ReportUtils.report((String)("trace for " + elements), (String)reportsPath, (String)("trace_" + elements + "_" + baseImageName), (String)"txt", writer -> writer.print(trace));
        String argument = SubstrateOptionsParser.commandArgument(option, String.join((CharSequence)",", patterns));
        return "Image building is interrupted as the " + elements + " specified via " + argument + " are reachable. See the generated report for a complete reachability trace: " + String.valueOf(path) + ". ";
    }

    public static void report(String imageName, OptionValues options, String reportsPath, BigBang bb) {
        StringWriter buf;
        List<String> fieldPatterns;
        StringWriter buf2;
        List<String> methodPatterns;
        StringWriter buf3;
        String baseImageName = ReportUtils.extractImageName((String)imageName);
        StringBuilder consoleMessageBuilder = new StringBuilder();
        List<String> typePatterns = ((AccumulatingLocatableMultiOptionValue.Strings)Options.AbortOnTypeReachable.getValue(options)).values();
        if (!typePatterns.isEmpty() && ReachabilityTracePrinter.printTraceForTypesImpl(typePatterns, bb, new PrintWriter(buf3 = new StringWriter())) > 0) {
            consoleMessageBuilder.append(ReachabilityTracePrinter.reportElements("type", buf3.toString(), reportsPath, baseImageName, typePatterns, Options.AbortOnTypeReachable));
        }
        if (!(methodPatterns = ((AccumulatingLocatableMultiOptionValue.Strings)Options.AbortOnMethodReachable.getValue(options)).values()).isEmpty() && ReachabilityTracePrinter.printTraceForMethodsImpl(methodPatterns, bb, new PrintWriter(buf2 = new StringWriter())) > 0) {
            consoleMessageBuilder.append(ReachabilityTracePrinter.reportElements("method", buf2.toString(), reportsPath, baseImageName, methodPatterns, Options.AbortOnMethodReachable));
        }
        if (!(fieldPatterns = ((AccumulatingLocatableMultiOptionValue.Strings)Options.AbortOnFieldReachable.getValue(options)).values()).isEmpty() && ReachabilityTracePrinter.printTraceForFieldsImpl(fieldPatterns, bb, new PrintWriter(buf = new StringWriter())) > 0) {
            consoleMessageBuilder.append(ReachabilityTracePrinter.reportElements("field", buf.toString(), reportsPath, baseImageName, fieldPatterns, Options.AbortOnFieldReachable));
        }
        if (!consoleMessageBuilder.isEmpty()) {
            throw AnalysisError.interruptAnalysis((String)consoleMessageBuilder.toString());
        }
    }

    private static int printTraceForTypesImpl(List<String> typePatterns, BigBang bb, PrintWriter writer) {
        ObjectTreePrinter.SimpleMatcher matcher = new ObjectTreePrinter.SimpleMatcher(typePatterns.toArray(new String[0]));
        int count = 0;
        for (AnalysisType type : bb.getUniverse().getTypes()) {
            if (!type.isReachable() || !matcher.matches(type.toJavaName(true))) continue;
            if (type.isInstantiated()) {
                header = "Type " + type.toJavaName() + " is marked as instantiated";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)type.getInstantiatedReason(), (String)header);
                writer.println(trace);
            } else {
                header = "Type " + type.toJavaName() + " is marked as reachable";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)type.getReachableReason(), (String)header);
                writer.println(trace);
            }
            ++count;
        }
        return count;
    }

    private static int printTraceForMethodsImpl(List<String> methodPatterns, BigBang bb, PrintWriter writer) {
        MethodFilter matcher = MethodFilter.parse((String)String.join((CharSequence)",", methodPatterns));
        int count = 0;
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            if (!method.isReachable() || !matcher.matches((JavaMethod)method)) continue;
            if (method.isIntrinsicMethod()) {
                header = "Method " + method.format("%H.%n(%p)") + " is intrinsic";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)method.getIntrinsicMethodReason(), (String)header);
                writer.println(trace);
            } else {
                header = "Method " + method.format("%H.%n(%p)") + " is called";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)method.getParsingReason(), (String)header);
                writer.println(trace);
            }
            ++count;
        }
        return count;
    }

    private static int printTraceForFieldsImpl(List<String> fieldPatterns, BigBang bb, PrintWriter writer) {
        ObjectTreePrinter.SimpleMatcher matcher = new ObjectTreePrinter.SimpleMatcher(fieldPatterns.toArray(new String[0]));
        int count = 0;
        for (AnalysisField field : bb.getUniverse().getFields()) {
            if (!field.isReachable() || !matcher.matches(field.getWrapped().format("%H.%n"))) continue;
            if (field.isWritten()) {
                header = "Field " + field.getName() + " is written";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getWrittenReason(), (String)header);
                writer.println(trace);
            } else if (field.isRead()) {
                header = "Field " + field.getName() + " is read";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getReadReason(), (String)header);
                writer.println(trace);
            } else if (field.isAccessed()) {
                header = "Field " + field.getName() + " is accessed unsafely";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getAccessedReason(), (String)header);
                writer.println(trace);
            } else {
                assert (field.isFolded());
                header = "Field " + field.getName() + " is folded";
                trace = AnalysisElement.ReachabilityTraceBuilder.buildReachabilityTrace((BigBang)bb, (Object)field.getFoldedReason(), (String)header);
                writer.println(trace);
            }
            ++count;
        }
        return count;
    }

    public static class Options {
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> AbortOnTypeReachable = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> AbortOnMethodReachable = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> AbortOnFieldReachable = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
    }
}

