/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.LambdaConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.JNIRegistryAdapter;
import com.oracle.svm.hosted.config.ReflectionRegistryAdapter;
import com.oracle.svm.hosted.lambda.LambdaParser;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.TypeResult;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.nativeimage.impl.RuntimeProxyCreationSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class RegistryAdapter
implements ReflectionConfigurationParserDelegate<ConfigurationCondition, Class<?>> {
    protected final ReflectionRegistry registry;
    private final ImageClassLoader classLoader;

    public static RegistryAdapter create(ReflectionRegistry registry, RuntimeProxyCreationSupport proxyRegistry, RuntimeSerializationSupport<ConfigurationCondition> serializationSupport, RuntimeJNIAccessSupport jniSupport, ImageClassLoader classLoader) {
        if (registry instanceof RuntimeReflectionSupport) {
            return new ReflectionRegistryAdapter((RuntimeReflectionSupport)registry, proxyRegistry, serializationSupport, jniSupport, classLoader);
        }
        if (registry instanceof RuntimeJNIAccessSupport) {
            return new JNIRegistryAdapter(registry, classLoader);
        }
        return new RegistryAdapter(registry, classLoader);
    }

    RegistryAdapter(ReflectionRegistry registry, ImageClassLoader classLoader) {
        this.registry = registry;
        this.classLoader = classLoader;
    }

    public void registerType(ConfigurationCondition condition, Class<?> type) {
        this.registry.register(condition, new Class[]{type});
    }

    public TypeResult<Class<?>> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives, boolean jniAccessible) {
        return TypeResult.toSingleElement(this.resolveTypes(condition, typeDescriptor, allowPrimitives, jniAccessible));
    }

    public TypeResult<List<Class<?>>> resolveTypes(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives, boolean jniAccessible) {
        TypeResult<List<Class<?>>> result = this.resolveTypesInternal(typeDescriptor, allowPrimitives);
        if (typeDescriptor.getDescriptorType() == ConfigurationTypeDescriptor.Kind.NAMED && !result.isPresent() && MissingRegistrationUtils.throwMissingRegistrationErrors() && result.getException() instanceof ClassNotFoundException) {
            this.registry.registerClassLookup(condition, result.getName());
        }
        return result;
    }

    private TypeResult<Class<?>> resolveTypeInternal(ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        switch (typeDescriptor.getDescriptorType()) {
            case NAMED: {
                return this.resolveNamedType((NamedConfigurationTypeDescriptor)typeDescriptor, allowPrimitives);
            }
            case PROXY: {
                return this.resolveProxyType((ProxyConfigurationTypeDescriptor)typeDescriptor);
            }
        }
        throw VMError.shouldNotReachHere("Unknown type descriptor kind: %s", typeDescriptor.getDescriptorType());
    }

    private TypeResult<List<Class<?>>> resolveTypesInternal(ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        if (Objects.requireNonNull(typeDescriptor.getDescriptorType()) == ConfigurationTypeDescriptor.Kind.LAMBDA) {
            return this.resolveLambdaType((LambdaConfigurationTypeDescriptor)typeDescriptor);
        }
        return TypeResult.toList(this.resolveTypeInternal(typeDescriptor, allowPrimitives));
    }

    private TypeResult<Class<?>> resolveNamedType(NamedConfigurationTypeDescriptor namedDescriptor, boolean allowPrimitives) {
        String reflectionName = ClassNameSupport.typeNameToReflectionName((String)namedDescriptor.name());
        TypeResult result = this.classLoader.findClass(reflectionName, allowPrimitives);
        if (!result.isPresent() && result.getException() instanceof NoClassDefFoundError) {
            try {
                Class.forName(reflectionName);
            }
            catch (ClassNotFoundException notFoundException) {
                result = TypeResult.forException((String)reflectionName, (Throwable)notFoundException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private TypeResult<Class<?>> resolveProxyType(ProxyConfigurationTypeDescriptor typeDescriptor) {
        String typeName = typeDescriptor.toString();
        List<TypeResult> interfaceResults = typeDescriptor.interfaceNames().stream().map(interfaceTypeName -> this.resolveNamedType(NamedConfigurationTypeDescriptor.fromTypeName((String)interfaceTypeName), false)).toList();
        ArrayList<Class> interfaces = new ArrayList<Class>();
        for (TypeResult intf : interfaceResults) {
            if (!intf.isPresent()) {
                return TypeResult.forException((String)typeName, (Throwable)intf.getException());
            }
            interfaces.add((Class)intf.get());
        }
        try {
            DynamicProxyRegistry proxyRegistry = (DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class);
            Class<?> proxyClass = proxyRegistry.getProxyClassHosted((Class[])interfaces.toArray(Class[]::new));
            return TypeResult.forType((String)typeName, proxyClass);
        }
        catch (Throwable t) {
            return TypeResult.forException((String)typeName, (Throwable)t);
        }
    }

    private TypeResult<List<Class<?>>> resolveLambdaType(LambdaConfigurationTypeDescriptor typeDescriptor) {
        TypeResult<Class<?>> declaringClass = this.resolveTypeInternal(typeDescriptor.declaringClass(), false);
        if (!declaringClass.isPresent()) {
            return TypeResult.forException((String)typeDescriptor.toString(), (Throwable)declaringClass.getException());
        }
        TypeResult<Method> declaringMethod = null;
        if (typeDescriptor.declaringMethod() != null && !(declaringMethod = this.resolveMethod((Class)declaringClass.get(), typeDescriptor.declaringMethod())).isPresent()) {
            return TypeResult.forException((String)typeDescriptor.toString(), (Throwable)declaringMethod.getException());
        }
        ArrayList implementedInterfaces = new ArrayList();
        for (NamedConfigurationTypeDescriptor interfaceDescriptor : typeDescriptor.interfaces()) {
            TypeResult<Class<?>> intf = this.resolveNamedType(interfaceDescriptor, false);
            if (!intf.isPresent()) {
                return TypeResult.forException((String)typeDescriptor.toString(), (Throwable)intf.getException());
            }
            implementedInterfaces.add((Class)intf.get());
        }
        try {
            List<Class<?>> lambdaClasses = declaringMethod == null ? LambdaParser.getLambdaClassesInClass((Class)declaringClass.get(), implementedInterfaces) : LambdaParser.getLambdaClassesInMethod((Method)declaringMethod.get(), implementedInterfaces);
            return !lambdaClasses.isEmpty() ? TypeResult.forType((String)typeDescriptor.toString(), lambdaClasses) : RegistryAdapter.exceptionResult((ConfigurationTypeDescriptor)typeDescriptor, declaringClass, declaringMethod, implementedInterfaces, null);
        }
        catch (Throwable t) {
            return RegistryAdapter.exceptionResult((ConfigurationTypeDescriptor)typeDescriptor, declaringClass, declaringMethod, implementedInterfaces, t);
        }
    }

    private static TypeResult<List<Class<?>>> exceptionResult(ConfigurationTypeDescriptor typeDescriptor, TypeResult<Class<?>> declaringClass, TypeResult<Method> declaringMethod, List<Class<?>> implementedInterfaces, Throwable cause) {
        NoClassDefFoundError error = new NoClassDefFoundError("No lambda class found in " + String.valueOf(declaringMethod != null ? (GenericDeclaration)declaringMethod.get() : (GenericDeclaration)declaringClass.get()) + " implementing " + String.valueOf(implementedInterfaces));
        if (cause != null) {
            error.initCause(cause);
        }
        return TypeResult.forException((String)typeDescriptor.toString(), (Throwable)error);
    }

    private TypeResult<Method> resolveMethod(Class<?> declaringClass, ConfigurationParser.ConfigurationMethodDescriptor methodDescriptor) {
        String name = methodDescriptor.name();
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        for (NamedConfigurationTypeDescriptor parameterType : methodDescriptor.parameterTypes()) {
            TypeResult<Class<?>> resolvedParameterType = this.resolveNamedType(parameterType, true);
            if (!resolvedParameterType.isPresent()) {
                return TypeResult.forException((String)resolvedParameterType.getName(), (Throwable)resolvedParameterType.getException());
            }
            parameterTypes.add((Class)resolvedParameterType.get());
        }
        try {
            return TypeResult.forType((String)methodDescriptor.toString(), (Object)declaringClass.getDeclaredMethod(name, (Class[])parameterTypes.toArray(Class[]::new)));
        }
        catch (NoSuchMethodException e) {
            return TypeResult.forException((String)methodDescriptor.toString(), (Throwable)e);
        }
    }

    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
    }

    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
    }

    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
    }

    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
    }

    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
    }

    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
    }

    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        if (!queriedOnly) {
            this.registry.register(condition, false, type.getFields());
        }
    }

    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        if (!queriedOnly) {
            this.registry.register(condition, false, type.getDeclaredFields());
        }
    }

    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getMethods());
    }

    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getDeclaredMethods());
    }

    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getConstructors());
    }

    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.registry.register(condition, queriedOnly, (Executable[])type.getDeclaredConstructors());
    }

    public final void registerField(ConfigurationCondition condition, Class<?> type, String fieldName, boolean allowWrite, boolean jniAccessible) throws NoSuchFieldException {
        try {
            this.registerField(condition, allowWrite, jniAccessible, type.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.registerFieldNegativeQuery(condition, jniAccessible, type, fieldName);
            }
            throw e;
        }
    }

    protected void registerField(ConfigurationCondition condition, boolean allowWrite, boolean jniAccessible, Field field) {
        this.registry.register(condition, allowWrite, new Field[]{field});
    }

    protected void registerFieldNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, String fieldName) {
        this.registry.registerFieldLookup(condition, type, fieldName);
    }

    public boolean registerAllMethodsWithName(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type, String methodName) {
        Method[] methods;
        boolean found = false;
        for (Method method : methods = type.getDeclaredMethods()) {
            if (!((Executable)method).getName().equals(methodName)) continue;
            this.registerExecutable(condition, queriedOnly, jniAccessible, method);
            found = true;
        }
        return found;
    }

    public boolean registerAllConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        Executable[] methods = type.getDeclaredConstructors();
        this.registerExecutable(condition, queriedOnly, jniAccessible, methods);
        return methods.length > 0;
    }

    public void registerUnsafeAllocated(ConfigurationCondition condition, Class<?> clazz) {
        if (!(clazz.isArray() || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()))) {
            this.registry.register(condition, true, clazz);
        }
    }

    public final void registerMethod(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, String methodName, List<Class<?>> methodParameterTypes, boolean jniAccessible) throws NoSuchMethodException {
        try {
            Method method;
            Class<?>[] parameterTypesArray = RegistryAdapter.getParameterTypes(methodParameterTypes);
            try {
                method = type.getDeclaredMethod(methodName, parameterTypesArray);
            }
            catch (NoClassDefFoundError e) {
                try {
                    method = type.getMethod(methodName, parameterTypesArray);
                }
                catch (Throwable ignored) {
                    throw e;
                }
            }
            this.registerExecutable(condition, queriedOnly, jniAccessible, method);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.registerMethodNegativeQuery(condition, jniAccessible, type, methodName, methodParameterTypes);
            }
            throw e;
        }
    }

    public final void registerConstructor(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, List<Class<?>> methodParameterTypes, boolean jniAccessible) throws NoSuchMethodException {
        Class<?>[] parameterTypesArray = RegistryAdapter.getParameterTypes(methodParameterTypes);
        try {
            this.registerExecutable(condition, queriedOnly, jniAccessible, type.getDeclaredConstructor(parameterTypesArray));
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.registerConstructorNegativeQuery(condition, jniAccessible, type, methodParameterTypes);
            }
            throw e;
        }
    }

    static Class<?>[] getParameterTypes(List<Class<?>> methodParameterTypes) {
        return (Class[])methodParameterTypes.toArray(Class[]::new);
    }

    protected void registerExecutable(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Executable ... executable) {
        this.registry.register(condition, queriedOnly, executable);
    }

    protected void registerMethodNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, String methodName, List<Class<?>> methodParameterTypes) {
        this.registry.registerMethodLookup(condition, type, methodName, (Class[])RegistryAdapter.getParameterTypes(methodParameterTypes));
    }

    protected void registerConstructorNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, List<Class<?>> constructorParameterTypes) {
        this.registry.registerConstructorLookup(condition, type, (Class[])RegistryAdapter.getParameterTypes(constructorParameterTypes));
    }

    public void registerAsSerializable(ConfigurationCondition condition, Class<?> clazz) {
    }

    public void registerAsJniAccessed(ConfigurationCondition condition, Class<?> clazz) {
    }

    public String getTypeName(Class<?> type) {
        return type.getTypeName();
    }

    public String getSimpleName(Class<?> type) {
        return ClassUtil.getUnqualifiedName(type);
    }
}

