/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.imagelayer.DynamicHubMetadataTracking;
import com.oracle.svm.hosted.imagelayer.LayeredImageHooks;
import com.oracle.svm.util.LogUtils;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class LayeredDynamicHubFeature
implements InternalFeature,
FeatureSingleton {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            LayeredImageHooks.registerDynamicHubWrittenCallback(this::onDynamicHubWritten);
        }
    }

    void onDynamicHubWritten(LayeredImageHooks.WrittenDynamicHubInfo info) {
        DynamicHub hub = info.hub();
        if (hub.getArrayHub() == null) {
            DynamicHubMetadataTracking.singleton().recordMissingArrayHub(hub);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            DynamicHubMetadataTracking tracking = DynamicHubMetadataTracking.singleton();
            FeatureImpl.BeforeCompilationAccessImpl config = (FeatureImpl.BeforeCompilationAccessImpl)access;
            config.getUniverse().getTypes().stream().filter(tracking::missingArrayHub).forEach(hType -> {
                if (hType.getHub().getArrayHub() != null) {
                    String missingArrayName = hType.getHub().getArrayHub().getName();
                    String message = String.format("New array type seen in application layer which was not installed within the dynamic hub.%nHub: %s%nArrayType: %s", hType.getHub().getName(), missingArrayName);
                    LogUtils.warning((String)message);
                }
            });
        }
    }
}

