/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayerArchiveSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class LoadLayerArchiveSupport
extends LayerArchiveSupport {
    public LoadLayerArchiveSupport(String layerName, Path layerFile, Path tempDir, ArchiveSupport archiveSupport) {
        super(layerName, layerFile, tempDir.resolve("layerRoot_load"), archiveSupport);
        this.archiveSupport.expandJarToDir(layerFile, this.layerDir);
        this.layerProperties.loadAndVerify();
        this.loadBuilderArgumentsFile();
    }

    private void loadBuilderArgumentsFile() {
        try (Stream<String> lines = Files.lines(this.getBuilderArgumentsFilePath());){
            lines.forEach(this.builderArguments::add);
        }
        catch (IOException e) {
            throw UserError.abort("Unable to load builder arguments from file " + String.valueOf(this.getBuilderArgumentsFilePath()), new Object[0]);
        }
    }

    @Override
    protected void validateLayerFile() {
        super.validateLayerFile();
        if (!Files.isReadable(this.layerFile)) {
            throw UserError.abort("The given layer file " + String.valueOf(this.layerFile) + " cannot be read.", new Object[0]);
        }
    }

    public void verifyCompatibility(NativeImageClassLoaderSupport classLoaderSupport, Map<String, HostedImageLayerBuildingSupport.OptionLayerVerificationRequests> allRequests, boolean strict, boolean verbose) {
        Function<String, String> filterFunction = argument -> LoadLayerArchiveSupport.splitArgumentOrigin((String)argument).argument;
        boolean violationsFound = false;
        violationsFound |= LoadLayerArchiveSupport.verifyCompatibility(this.builderArguments, classLoaderSupport.getHostedOptionParser().getArguments(), filterFunction, allRequests, strict, verbose, true);
        if ((violationsFound |= LoadLayerArchiveSupport.verifyCompatibility(this.builderArguments, classLoaderSupport.getHostedOptionParser().getArguments(), filterFunction, allRequests, strict, verbose, false)) && verbose) {
            UserError.abort("Verbose LayerOptionVerification failed.", new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean verifyCompatibility(List<String> previousArgs, List<String> currentArgs, Function<String, String> filterFunction, Map<String, HostedImageLayerBuildingSupport.OptionLayerVerificationRequests> allRequests, boolean strict, boolean verbose, boolean positional) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=9,513
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ArgumentOrigin splitArgumentOrigin(String argumentWithOrigin) {
        int booleanPrefixPos = argumentWithOrigin.indexOf(58) + 1;
        char booleanPrefixChar = argumentWithOrigin.charAt(booleanPrefixPos);
        boolean booleanOption = booleanPrefixChar == '+' || booleanPrefixChar == '-';
        Object argument = argumentWithOrigin;
        String origin = "";
        if (booleanOption) {
            int originSeperatorPos = argumentWithOrigin.lastIndexOf(64);
            if (originSeperatorPos >= 0) {
                argument = argumentWithOrigin.substring(0, originSeperatorPos);
                origin = argumentWithOrigin.substring(originSeperatorPos + 1);
            }
        } else {
            int originSeparatorPos = argumentWithOrigin.indexOf(64);
            if (originSeparatorPos >= 0) {
                int keyValueSeparatorPos = argumentWithOrigin.indexOf(61);
                argument = argumentWithOrigin.substring(0, originSeparatorPos) + argumentWithOrigin.substring(keyValueSeparatorPos);
                origin = argumentWithOrigin.substring(originSeparatorPos + 1, keyValueSeparatorPos);
            }
        }
        return new ArgumentOrigin(booleanOption, (String)argument, origin);
    }

    record ArgumentOrigin(boolean booleanOption, String argument, String origin) {
        NameValue nameValue() {
            String value;
            String name;
            if (this.booleanOption) {
                name = this.argument.substring(4);
                value = String.valueOf(this.argument.charAt(3));
            } else {
                int valueSep = this.argument.indexOf(61);
                name = this.argument.substring(3, valueSep);
                value = this.argument.substring(valueSep + 1);
            }
            return new NameValue(name, value);
        }

        record NameValue(String name, String value) {
        }
    }
}

