/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdMap;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.jfr.JfrEventSubstitution;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import sun.nio.ch.FileChannelImpl;

@AutomaticallyRegisteredFeature
public class JfrEventFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JfrFeature.isInConfiguration(false);
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(JfrFeature.class, ReflectionFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        RuntimeReflection.registerFieldLookup(Throwable.class, (String)"jfrTracing");
        RuntimeReflection.registerFieldLookup(FileInputStream.class, (String)"jfrTracing");
        RuntimeReflection.registerFieldLookup(FileOutputStream.class, (String)"jfrTracing");
        RuntimeReflection.registerFieldLookup(FileChannelImpl.class, (String)"jfrTracing");
        RuntimeReflection.registerFieldLookup(RandomAccessFile.class, (String)"jfrTracing");
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        MetaAccessProvider metaAccess = config.getMetaAccess().getWrapped();
        for (Class<Event> eventSubClass : config.findSubclasses(Event.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{eventSubClass.getName()});
        }
        config.registerSubstitutionProcessor(new JfrEventSubstitution(metaAccess, config.getUniverse().getHeapScanner()));
        Field configField = ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"jfrEventConfiguration");
        FieldValueInterceptionSupport.singleton().registerFieldValueTransformer(configField, (FieldValueTransformer)new FieldValueTransformerWithAvailability(this){

            @Override
            public boolean isAvailable() {
                return BuildPhaseProvider.isHostedUniverseBuilt();
            }

            public Object transform(Object receiver, Object originalValue) {
                return originalValue;
            }
        });
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        int mapSize = DynamicHubSupport.currentLayer().getMaxTypeId() + 1;
        ((JfrTraceIdMap)ImageSingletons.lookup(JfrTraceIdMap.class)).initialize(mapSize);
        Collection<? extends SharedType> types = ((FeatureImpl.CompilationAccessImpl)a).getTypes();
        for (SharedType sharedType : types) {
            DynamicHub hub = sharedType.getHub();
            Class<?> clazz = hub.getHostedJavaClass();
            JfrTraceId.assign(clazz, hub.getTypeID() + 1);
        }
        FeatureImpl.CompilationAccessImpl accessImpl = (FeatureImpl.CompilationAccessImpl)a;
        for (Class<? extends Event> newEventClass : JfrJavaEvents.getAllEventClasses()) {
            Object ec = JVM.getConfiguration(newEventClass);
            DynamicHub dynamicHub = accessImpl.getMetaAccess().lookupJavaType((Class)newEventClass).getHub();
            dynamicHub.setJrfEventConfiguration(ec);
        }
    }
}

