/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.heap.TypedConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.meta.MethodOffset;
import com.oracle.svm.core.meta.MethodPointer;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.WordBase;

public class PatchedWordConstant
implements JavaConstant,
TypedConstant {
    private final WordBase word;
    private final AnalysisType type;

    public PatchedWordConstant(WordBase word, AnalysisType type) {
        this.word = word;
        this.type = type;
    }

    public WordBase getWord() {
        return this.word;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        throw new IllegalArgumentException();
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public AnalysisType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.word.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PatchedWordConstant) {
            PatchedWordConstant rc = (PatchedWordConstant)obj;
            return this.word == rc.word;
        }
        return false;
    }

    public String toValueString() {
        WordBase wordBase = this.word;
        if (wordBase instanceof MethodPointer) {
            MethodPointer mp = (MethodPointer)wordBase;
            return "relocatable method pointer: " + mp.getMethod().format("%H.%n(%p)") + ", permitsRewriteToPLT: " + mp.permitsRewriteToPLT();
        }
        wordBase = this.word;
        if (wordBase instanceof MethodOffset) {
            MethodOffset mo = (MethodOffset)wordBase;
            return "method offset: " + mo.getMethod().format("%H.%n(%p)");
        }
        return "patched word constant";
    }
}

