/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupport;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class GOTEntryAllocator {
    public static final int GOT_NO_ENTRY = -2;
    private final ConcurrentHashMap<SharedMethod, Integer> gotMap = new ConcurrentHashMap();
    private SharedMethod[] got = null;
    private final AtomicInteger currentFreeEntry = new AtomicInteger(0);

    public int getMethodGotEntry(SharedMethod method) {
        return this.gotMap.computeIfAbsent(method, m -> this.currentFreeEntry.getAndIncrement());
    }

    public void reserveMethodGotEntry(SharedMethod method) {
        this.getMethodGotEntry(method);
    }

    public int queryGotEntry(SharedMethod method) {
        assert (this.hasGOTLayout());
        return this.gotMap.getOrDefault(method, -2);
    }

    public void reserveAndLayout(Set<HostedMethod> methods, MethodAddressResolutionSupport resolver) {
        assert (!this.hasGOTLayout());
        methods.stream().filter(resolver::shouldCallViaPLTGOT).forEach(this::reserveMethodGotEntry);
        VMError.guarantee(this.got == null, "Can layout the GOT only once.");
        this.got = new SharedMethod[((ConcurrentHashMap.CollectionView)((Object)this.gotMap.keySet())).size()];
        for (Map.Entry<SharedMethod, Integer> entry : this.gotMap.entrySet()) {
            this.got[entry.getValue().intValue()] = entry.getKey();
        }
    }

    public boolean hasGOTLayout() {
        return this.got != null;
    }

    public SharedMethod[] getGOT() {
        VMError.guarantee(this.got != null, "Must layout the GOT first before use.");
        return this.got;
    }
}

