/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;

public final class InterpreterFrame {
    private final long[] primitives;
    private final Object[] references;
    private final Object[] arguments;
    private Object[] locks;
    private int lockCount;
    private static final Object[] EMPTY = new Object[0];

    private InterpreterFrame(int slotCount, Object[] arguments) {
        this.primitives = new long[slotCount];
        this.references = new Object[slotCount];
        this.arguments = arguments;
        this.lockCount = 0;
        this.locks = EMPTY;
    }

    static InterpreterFrame create(int slotCount, Object ... arguments) {
        return new InterpreterFrame(slotCount, arguments);
    }

    Object[] getArguments() {
        return this.arguments;
    }

    int getIntStatic(int slot) {
        return (int)this.primitives[slot];
    }

    Object getObjectStatic(int slot) {
        return this.references[slot];
    }

    float getFloatStatic(int slot) {
        return Float.intBitsToFloat((int)this.primitives[slot]);
    }

    long getLongStatic(int slot) {
        return this.primitives[slot];
    }

    double getDoubleStatic(int slot) {
        return Double.longBitsToDouble(this.primitives[slot]);
    }

    void setObjectStatic(int slot, Object value) {
        this.references[slot] = value;
    }

    void setIntStatic(int slot, int value) {
        this.primitives[slot] = value;
    }

    void setFloatStatic(int slot, float value) {
        this.primitives[slot] = Float.floatToRawIntBits(value);
    }

    void setLongStatic(int slot, long value) {
        this.primitives[slot] = value;
    }

    void setDoubleStatic(int slot, double value) {
        this.primitives[slot] = Double.doubleToRawLongBits(value);
    }

    void clearObjectStatic(int slot) {
        this.references[slot] = null;
    }

    void clearPrimitiveStatic(int slot) {
        this.primitives[slot] = 0L;
    }

    void clearStatic(int slot) {
        this.clearObjectStatic(slot);
        this.clearPrimitiveStatic(slot);
    }

    void swapStatic(int src, int dst) {
        long tmp = this.primitives[src];
        this.primitives[src] = this.primitives[dst];
        this.primitives[dst] = tmp;
        Object otmp = this.references[src];
        this.references[src] = this.references[dst];
        this.references[dst] = otmp;
    }

    void copyStatic(int src, int dst) {
        this.primitives[dst] = this.primitives[src];
        this.references[dst] = this.references[src];
    }

    private void ensureLocksCapacity(int capacity) {
        int oldLength = this.locks.length;
        Object[] newLocks = Arrays.copyOf(this.locks, Math.max(capacity, oldLength * 2 + 1));
        this.locks = newLocks;
    }

    void addLock(Object ref) {
        assert (ref != null);
        assert (MonitorSupport.singleton().isLockedByCurrentThread(ref));
        if (this.lockCount >= 0) {
            if (this.lockCount >= this.locks.length) {
                this.ensureLocksCapacity(this.lockCount + 1);
            }
            this.locks[this.lockCount++] = ref;
        } else {
            for (int i = 0; i < this.locks.length; ++i) {
                if (this.locks[i] != null) continue;
                this.locks[i] = ref;
                return;
            }
            int oldLockCount = this.locks.length;
            this.ensureLocksCapacity(oldLockCount + 1);
            assert (this.locks[oldLockCount] == null);
            this.locks[oldLockCount] = ref;
        }
    }

    void removeLock(Object ref) {
        assert (ref != null);
        if (this.lockCount <= 0 || this.locks[this.lockCount - 1] != ref) {
            this.lockCount = -1;
            for (int i = 0; i < this.locks.length; ++i) {
                if (this.locks[i] != ref) continue;
                this.locks[i] = null;
                return;
            }
            throw VMError.shouldNotReachHere("lock not found in interpreter frame");
        }
        this.locks[--this.lockCount] = null;
    }

    Object[] getLocks() {
        return this.locks;
    }
}

