/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.hosted.pltgot.PLTGOTOptions;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;

public class InterpreterOptions {
    public static final HostedOptionKey<Boolean> DebuggerWithInterpreter = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
            if (newValue.booleanValue()) {
                PLTGOTOptions.EnablePLTGOT.update(values, true);
            }
        }
    };
    public static final HostedOptionKey<Boolean> InterpreterBuildTimeLogging = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<String> InterpreterDumpClassFiles = new HostedOptionKey<String>("");
    public static final HostedOptionKey<Boolean> InterpreterTraceSupport = new HostedOptionKey<Boolean>(true);
    public static final RuntimeOptionKey<Boolean> InterpreterTrace = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);

    public static boolean interpreterEnabled() {
        return DebuggerWithInterpreter.getValue() != false || RuntimeClassLoading.isSupported();
    }
}

