/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class Unsigned5 {
    private static final int lg_H = 6;
    private static final int H = 64;
    private static final int X = 1;
    private static final int MAX_b = 255;
    private static final int L = 191;
    private static final int MAX_LENGTH = 5;

    public static void writeUnsignedInt(DataOutput out, int value) throws IOException {
        int sum = value;
        for (int i = 0; i < 4 && Integer.compareUnsigned(sum, 191) >= 0; ++i) {
            out.writeByte((byte)(192 + ((sum -= 191) & 0x3F)));
            sum >>>= 6;
        }
        out.writeByte((byte)(1 + sum));
    }

    public static int readUnsignedInt(DataInput in) throws IOException {
        int sum = 0;
        for (int i = 0; i < 5; ++i) {
            int bi = in.readUnsignedByte();
            if (bi < 1) {
                throw new IllegalStateException("Invalid byte");
            }
            sum += bi - 1 << i * 6;
            if (bi < 192) break;
        }
        return sum;
    }
}

