/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class TypeTag {
    public static final byte CLASS = 1;
    public static final byte INTERFACE = 2;
    public static final byte ARRAY = 3;

    private TypeTag() {
    }

    public static byte getKind(ResolvedJavaType type) {
        if (type.isArray()) {
            return 3;
        }
        if (type.isInterface()) {
            return 2;
        }
        VMError.guarantee(!type.isPrimitive());
        return 1;
    }

    public static boolean isValidTypeTag(byte kind) {
        return kind == 1 || kind == 2 || kind == 3;
    }
}

