// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: AllocationSite.Options.java
package com.oracle.svm.core.allocationprofile;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class AllocationSite_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(AllocationSite.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AllocationProfiling": {
            return OptionDescriptor.create(
                /*name*/ "AllocationProfiling",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable runtime profiling of allocation",
                /*container*/ getContainer(),
                /*option*/ AllocationSite.Options.AllocationProfiling,
                /*fieldName*/ "AllocationProfiling",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocationProfilingThreshold": {
            return OptionDescriptor.create(
                /*name*/ "AllocationProfilingThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The minimum size in bytes required for printing an allocation profiling entry",
                /*container*/ getContainer(),
                /*option*/ AllocationSite.Options.AllocationProfilingThreshold,
                /*fieldName*/ "AllocationProfilingThreshold",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintDetailedAllocationProfiling": {
            return OptionDescriptor.create(
                /*name*/ "PrintDetailedAllocationProfiling",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print detailed information for each allocation site",
                /*container*/ getContainer(),
                /*option*/ AllocationSite.Options.PrintDetailedAllocationProfiling,
                /*fieldName*/ "PrintDetailedAllocationProfiling",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllocationProfiling");
                    case 1: return get("AllocationProfilingThreshold");
                    case 2: return get("PrintDetailedAllocationProfiling");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
