// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: ReachabilityTracePrinter.Options.java
package com.oracle.svm.hosted.analysis;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class ReachabilityTracePrinter_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(ReachabilityTracePrinter.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AbortOnFieldReachable": {
            return OptionDescriptor.create(
                /*name*/ "AbortOnFieldReachable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Print a trace and abort the build process if any field matching the specified pattern becomes reachable.",
                /*container*/ getContainer(),
                /*option*/ ReachabilityTracePrinter.Options.AbortOnFieldReachable,
                /*fieldName*/ "AbortOnFieldReachable",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AbortOnMethodReachable": {
            return OptionDescriptor.create(
                /*name*/ "AbortOnMethodReachable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Print a trace and abort the build process if any method matching the specified pattern becomes reachable.",
                /*container*/ getContainer(),
                /*option*/ ReachabilityTracePrinter.Options.AbortOnMethodReachable,
                /*fieldName*/ "AbortOnMethodReachable",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AbortOnTypeReachable": {
            return OptionDescriptor.create(
                /*name*/ "AbortOnTypeReachable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Print a trace and abort the build process if any type matching the specified pattern becomes reachable.",
                /*container*/ getContainer(),
                /*option*/ ReachabilityTracePrinter.Options.AbortOnTypeReachable,
                /*fieldName*/ "AbortOnTypeReachable",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AbortOnFieldReachable");
                    case 1: return get("AbortOnMethodReachable");
                    case 2: return get("AbortOnTypeReachable");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
