// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: CompilationTask.Options.java
package jdk.graal.compiler.hotspot;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class CompilationTask_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(CompilationTask.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "DetectRecompilationLimit": {
            return OptionDescriptor.create(
                /*name*/ "DetectRecompilationLimit",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "When the number of recompilations exceeds the limit, enable the detection of repeated identical deopts and report the source of the deopt loop when detected. Negative value means the limit is disabled. The default is -1 (disabled).",
                /*container*/ getContainer(),
                /*option*/ CompilationTask.Options.DetectRecompilationLimit,
                /*fieldName*/ "DetectRecompilationLimit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MethodRecompilationLimit": {
            return OptionDescriptor.create(
                /*name*/ "MethodRecompilationLimit",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Hard limit on the number of recompilations to avoid deopt loops. Exceeding the limit results in a permanent bailout. Negative value means the limit is disabled. The default is -1 (disabled).",
                /*container*/ getContainer(),
                /*option*/ CompilationTask.Options.MethodRecompilationLimit,
                /*fieldName*/ "MethodRecompilationLimit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerMethodOptions": {
            return OptionDescriptor.create(
                /*name*/ "PerMethodOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Options which are enabled based on the method being compiled.
The basic syntax is a MethodFilter option specification followed by a list of options to be set for that compilation.
\"MethodFilter:\" is used to distinguish this from normal usage of MethodFilter as option.
This can be repeated multiple times with each MethodFilter option separating the groups.
For example:
\"    -Djdk.graal.PerMethodOptions=MethodFilter:String.indexOf SpeculativeGuardMovement=false MethodFilter:Integer.* SpeculativeGuardMovement=false
disables SpeculativeGuardMovement for compiles of String.indexOf and all methods in Integer.
If the value starts with a non-letter character, that
character is used as the separator between options instead of a space.""",
                /*container*/ getContainer(),
                /*option*/ CompilationTask.Options.PerMethodOptions,
                /*fieldName*/ "PerMethodOptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("DetectRecompilationLimit");
                    case 1: return get("MethodRecompilationLimit");
                    case 2: return get("PerMethodOptions");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
