/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.isolated.ClientHandle;
import com.oracle.svm.core.graal.isolated.ClientIsolateThread;
import com.oracle.svm.core.graal.isolated.CompilerHandle;
import com.oracle.svm.core.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.core.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.core.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.BinaryInput;
import com.oracle.svm.truffle.isolated.BinaryOutput;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedTruffleSourceLanguagePosition;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleSourceLanguagePosition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

final class IsolatedTruffleCompilationTask
extends IsolatedObjectProxy<TruffleCompilationTask>
implements TruffleCompilationTask {
    IsolatedTruffleCompilationTask(ClientHandle<TruffleCompilationTask> handle) {
        super(handle);
    }

    public boolean isCancelled() {
        return IsolatedTruffleCompilationTask.isCancelled0(IsolatedCompileContext.get().getClient(), (ClientHandle<TruffleCompilationTask>)this.handle);
    }

    public boolean isLastTier() {
        return IsolatedTruffleCompilationTask.isLastTier0(IsolatedCompileContext.get().getClient(), (ClientHandle<TruffleCompilationTask>)this.handle);
    }

    public boolean isFirstTier() {
        return IsolatedTruffleCompilationTask.isFirstTier0(IsolatedCompileContext.get().getClient(), (ClientHandle<TruffleCompilationTask>)this.handle);
    }

    public boolean hasNextTier() {
        return IsolatedTruffleCompilationTask.hasNextTier0(IsolatedCompileContext.get().getClient(), (ClientHandle<TruffleCompilationTask>)this.handle);
    }

    public TruffleSourceLanguagePosition getPosition(JavaConstant nodeConstant) {
        if (!(nodeConstant instanceof IsolatedObjectConstant)) {
            return null;
        }
        ClientHandle nodeConstantHandle = ((IsolatedObjectConstant)nodeConstant).getHandle();
        CompilerHandle<TruffleSourceLanguagePosition> position = IsolatedTruffleCompilationTask.getPosition0(IsolatedCompileContext.get().getClient(), (ClientHandle<? extends TruffleCompilationTask>)this.handle, nodeConstantHandle);
        return (TruffleSourceLanguagePosition)IsolatedCompileContext.get().unhand(position);
    }

    public Map<String, Object> getDebugProperties(JavaConstant nodeConstant) {
        if (!(nodeConstant instanceof IsolatedObjectConstant)) {
            return Collections.emptyMap();
        }
        ClientHandle nodeConstantHandle = ((IsolatedObjectConstant)nodeConstant).getHandle();
        LinkedHashMap<String, Object> debugProperties = new LinkedHashMap<String, Object>();
        CompilerHandle debugPropertiesHandle = IsolatedCompileContext.get().hand(debugProperties);
        IsolatedTruffleCompilationTask.getDebugProperties0(IsolatedCompileContext.get().getClient(), (ClientHandle<? extends TruffleCompilationTask>)this.handle, nodeConstantHandle, (CompilerHandle<Map<String, Object>>)debugPropertiesHandle);
        return debugProperties;
    }

    public void addTargetToDequeue(TruffleCompilable target) {
        ClientHandle targetHandle = ((IsolatedCompilableTruffleAST)target).getHandle();
        IsolatedTruffleCompilationTask.addTargetToDequeue0(IsolatedCompileContext.get().getClient(), (ClientHandle<? extends TruffleCompilationTask>)this.handle, (ClientHandle<SubstrateCompilableTruffleAST>)targetHandle);
    }

    public void setCallCounts(int total, int inlined) {
        IsolatedTruffleCompilationTask.setCallCounts0(IsolatedCompileContext.get().getClient(), (ClientHandle<? extends TruffleCompilationTask>)this.handle, total, inlined);
    }

    public void addInlinedTarget(TruffleCompilable target) {
        ClientHandle targetHandle = ((IsolatedCompilableTruffleAST)target).getHandle();
        IsolatedTruffleCompilationTask.addInlinedTarget0(IsolatedCompileContext.get().getClient(), (ClientHandle<? extends TruffleCompilationTask>)this.handle, (ClientHandle<SubstrateCompilableTruffleAST>)targetHandle);
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean isCancelled0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return ((TruffleCompilationTask)IsolatedCompileClient.get().unhand(taskHandle)).isCancelled();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean isLastTier0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return ((TruffleCompilationTask)IsolatedCompileClient.get().unhand(taskHandle)).isLastTier();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean isFirstTier0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return ((TruffleCompilationTask)IsolatedCompileClient.get().unhand(taskHandle)).isFirstTier();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean hasNextTier0(ClientIsolateThread client, ClientHandle<TruffleCompilationTask> taskHandle) {
        return ((TruffleCompilationTask)IsolatedCompileClient.get().unhand(taskHandle)).hasNextTier();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static CompilerHandle<TruffleSourceLanguagePosition> getPosition0(ClientIsolateThread client, ClientHandle<? extends TruffleCompilationTask> inliningHandle, ClientHandle<?> callNodeConstantHandle) {
        JavaConstant callNodeConstant;
        TruffleCompilationTask task = (TruffleCompilationTask)IsolatedCompileClient.get().unhand(inliningHandle);
        TruffleSourceLanguagePosition position = task.getPosition(callNodeConstant = SubstrateObjectConstant.forObject((Object)IsolatedCompileClient.get().unhand(callNodeConstantHandle)));
        if (position == null) {
            return (CompilerHandle)IsolatedHandles.nullHandle();
        }
        return IsolatedTruffleCompilationTask.createPositionInCompiler(IsolatedCompileClient.get().getCompiler(), (ClientHandle<TruffleSourceLanguagePosition>)IsolatedCompileClient.get().hand((Object)position), position.getLineNumber(), position.getOffsetStart(), position.getOffsetEnd(), position.getNodeId());
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static void fillDebugProperties0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread context, ClientIsolateThread client, CCharPointer buffer, int bufferLength, CompilerHandle<Map<String, Object>> targetPropertiesHandle) {
        Map targetProperties = (Map)IsolatedCompileContext.get().unhand(targetPropertiesHandle);
        IsolatedTruffleCompilationTask.readDebugMap(targetProperties, BinaryInput.create(buffer, bufferLength));
    }

    private static Map<String, Object> readDebugMap(Map<String, Object> map, BinaryInput in) {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = in.readTypedValue();
            map.put(key, value);
        }
        return map;
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void getDebugProperties0(ClientIsolateThread client, ClientHandle<? extends TruffleCompilationTask> inliningHandle, ClientHandle<?> callNodeConstantHandle, CompilerHandle<Map<String, Object>> targetProperties) {
        TruffleCompilationTask task = (TruffleCompilationTask)IsolatedCompileClient.get().unhand(inliningHandle);
        JavaConstant callNodeConstant = SubstrateObjectConstant.forObject((Object)IsolatedCompileClient.get().unhand(callNodeConstantHandle));
        Map debugProperties = task.getDebugProperties(callNodeConstant);
        BinaryOutput.ByteArrayBinaryOutput out = BinaryOutput.create();
        IsolatedTruffleCompilationTask.writeDebugMap(out, debugProperties);
        byte[] array = out.getArray();
        try (CTypeConversion.CCharPointerHolder pin = CTypeConversion.toCBytes((byte[])array);){
            IsolatedTruffleCompilationTask.fillDebugProperties0(IsolatedCompileClient.get().getCompiler(), client, pin.get(), array.length, targetProperties);
        }
    }

    private static void writeDebugMap(BinaryOutput out, Map<String, Object> map) {
        out.writeInt(map.size());
        for (Map.Entry<String, Object> e : map.entrySet()) {
            out.writeUTF(e.getKey());
            IsolatedTruffleCompilationTask.writeDebugMapValue(out, e.getValue());
        }
    }

    private static void writeDebugMapValue(BinaryOutput out, Object object) {
        Object useValue = object;
        if (!BinaryOutput.isTypedValue(useValue)) {
            useValue = object.toString();
        }
        out.writeTypedValue(useValue);
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void addTargetToDequeue0(ClientIsolateThread client, ClientHandle<? extends TruffleCompilationTask> providerHandle, ClientHandle<SubstrateCompilableTruffleAST> targetHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        TruffleCompilationTask task = (TruffleCompilationTask)isolatedCompileClient.unhand(providerHandle);
        task.addTargetToDequeue((TruffleCompilable)isolatedCompileClient.unhand(targetHandle));
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void addInlinedTarget0(ClientIsolateThread client, ClientHandle<? extends TruffleCompilationTask> providerHandle, ClientHandle<SubstrateCompilableTruffleAST> targetHandle) {
        IsolatedCompileClient isolatedCompileClient = IsolatedCompileClient.get();
        TruffleCompilationTask task = (TruffleCompilationTask)isolatedCompileClient.unhand(providerHandle);
        task.addInlinedTarget((TruffleCompilable)isolatedCompileClient.unhand(targetHandle));
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void setCallCounts0(ClientIsolateThread client, ClientHandle<? extends TruffleCompilationTask> handle, int total, int inlined) {
        TruffleCompilationTask task = (TruffleCompilationTask)IsolatedCompileClient.get().unhand(handle);
        task.setCallCounts(total, inlined);
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static CompilerHandle<TruffleSourceLanguagePosition> createPositionInCompiler(CompilerIsolateThread compiler, ClientHandle<TruffleSourceLanguagePosition> positionHandle, int lineNumber, int offsetStart, int offsetEnd, int nodeId) {
        return IsolatedCompileContext.get().hand((Object)new IsolatedTruffleSourceLanguagePosition(positionHandle, lineNumber, offsetStart, offsetEnd, nodeId));
    }
}

