/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.dwarf.DwarfARangesSectionImpl;
import com.oracle.objectfile.dwarf.DwarfAbbrevSectionImpl;
import com.oracle.objectfile.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.dwarf.DwarfFrameSectionImpl;
import com.oracle.objectfile.dwarf.DwarfFrameSectionImplAArch64;
import com.oracle.objectfile.dwarf.DwarfFrameSectionImplX86_64;
import com.oracle.objectfile.dwarf.DwarfInfoSectionImpl;
import com.oracle.objectfile.dwarf.DwarfLineSectionImpl;
import com.oracle.objectfile.dwarf.DwarfLocSectionImpl;
import com.oracle.objectfile.dwarf.DwarfRangesSectionImpl;
import com.oracle.objectfile.dwarf.DwarfStrSectionImpl;
import com.oracle.objectfile.dwarf.constants.DwarfSectionName;
import com.oracle.objectfile.elf.ELFMachine;
import java.nio.ByteOrder;

public class ELFDebugInfo
extends DwarfDebugInfo {
    private final DwarfStrSectionImpl dwarfStrSection;
    private final DwarfAbbrevSectionImpl dwarfAbbrevSection;
    private final DwarfInfoSectionImpl dwarfInfoSection;
    private final DwarfLocSectionImpl dwarfLocSection;
    private final DwarfARangesSectionImpl dwarfARangesSection;
    private final DwarfRangesSectionImpl dwarfRangesSection;
    private final DwarfLineSectionImpl dwarfLineSection;
    private final DwarfFrameSectionImpl dwarfFameSection;
    public final ELFMachine elfMachine;
    private final byte heapbaseRegister;
    private final byte threadRegister;

    public ELFDebugInfo(ELFMachine elfMachine, ByteOrder byteOrder) {
        super(byteOrder);
        this.elfMachine = elfMachine;
        this.dwarfStrSection = new DwarfStrSectionImpl(this);
        this.dwarfAbbrevSection = new DwarfAbbrevSectionImpl(this);
        this.dwarfInfoSection = new DwarfInfoSectionImpl(this);
        this.dwarfLocSection = new DwarfLocSectionImpl(this);
        this.dwarfARangesSection = new DwarfARangesSectionImpl(this);
        this.dwarfRangesSection = new DwarfRangesSectionImpl(this);
        this.dwarfLineSection = new DwarfLineSectionImpl(this);
        if (elfMachine == ELFMachine.AArch64) {
            this.dwarfFameSection = new DwarfFrameSectionImplAArch64(this);
            this.heapbaseRegister = (byte)27;
            this.threadRegister = (byte)28;
        } else {
            this.dwarfFameSection = new DwarfFrameSectionImplX86_64(this);
            this.heapbaseRegister = (byte)14;
            this.threadRegister = (byte)15;
        }
    }

    public DwarfStrSectionImpl getStrSectionImpl() {
        return this.dwarfStrSection;
    }

    public DwarfAbbrevSectionImpl getAbbrevSectionImpl() {
        return this.dwarfAbbrevSection;
    }

    public DwarfFrameSectionImpl getFrameSectionImpl() {
        return this.dwarfFameSection;
    }

    public DwarfInfoSectionImpl getInfoSectionImpl() {
        return this.dwarfInfoSection;
    }

    public DwarfLocSectionImpl getLocSectionImpl() {
        return this.dwarfLocSection;
    }

    public DwarfARangesSectionImpl getARangesSectionImpl() {
        return this.dwarfARangesSection;
    }

    public DwarfRangesSectionImpl getRangesSectionImpl() {
        return this.dwarfRangesSection;
    }

    public DwarfLineSectionImpl getLineSectionImpl() {
        return this.dwarfLineSection;
    }

    @Override
    public byte getHeapbaseRegister() {
        return this.heapbaseRegister;
    }

    public byte getThreadRegister() {
        return this.threadRegister;
    }

    @Override
    public boolean isAarch64() {
        return this.elfMachine == ELFMachine.AArch64;
    }

    @Override
    public boolean isAMD64() {
        return this.elfMachine == ELFMachine.X86_64;
    }

    @Override
    public DwarfSectionName textSectionName() {
        return ELFSectionName.TEXT_SECTION;
    }

    @Override
    public DwarfSectionName lineSectionName() {
        return ELFSectionName.DW_LINE_SECTION;
    }

    @Override
    public DwarfSectionName strSectionName() {
        return ELFSectionName.DW_STR_SECTION;
    }

    @Override
    public DwarfSectionName locSectionName() {
        return ELFSectionName.DW_LOC_SECTION;
    }

    @Override
    public DwarfSectionName rangesSectionName() {
        return ELFSectionName.DW_RANGES_SECTION;
    }

    @Override
    public DwarfSectionName arangesSectionName() {
        return ELFSectionName.DW_ARANGES_SECTION;
    }

    @Override
    public DwarfSectionName frameSectionName() {
        return ELFSectionName.DW_FRAME_SECTION;
    }

    @Override
    public DwarfSectionName abbrevSectionName() {
        return ELFSectionName.DW_ABBREV_SECTION;
    }

    @Override
    public DwarfSectionName infoSectionName() {
        return ELFSectionName.DW_INFO_SECTION;
    }

    static enum ELFSectionName implements DwarfSectionName
    {
        TEXT_SECTION(".text"),
        DW_STR_SECTION(".debug_str"),
        DW_LINE_SECTION(".debug_line"),
        DW_FRAME_SECTION(".debug_frame"),
        DW_ABBREV_SECTION(".debug_abbrev"),
        DW_INFO_SECTION(".debug_info"),
        DW_LOC_SECTION(".debug_loc"),
        DW_ARANGES_SECTION(".debug_aranges"),
        DW_RANGES_SECTION(".debug_ranges");

        private final String value;

        private ELFSectionName(String s) {
            this.value = s;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

