/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.SymbolsImpl;
import java.util.Arrays;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Symbols {
    public static Symbols fromExisting(Set<Symbol<?>> existingSymbols, int initialSymbolTable) {
        return Symbols.fromExisting(existingSymbols, initialSymbolTable, initialSymbolTable);
    }

    public static Symbols fromExisting(Set<Symbol<?>> existingSymbols, int initialStrongSize, int initialWeakSize) {
        return new SymbolsImpl(existingSymbols, initialStrongSize, initialWeakSize);
    }

    abstract <T> Symbol<T> lookup(ByteSequence var1);

    <T> Symbol<T> lookup(String string) {
        return this.lookup(ByteSequence.create(string));
    }

    <T> Symbol<T> getOrCreate(ByteSequence byteSequence) {
        return this.getOrCreate(byteSequence, false);
    }

    abstract <T> Symbol<T> getOrCreate(ByteSequence var1, boolean var2);

    abstract boolean isWeak(Symbol<?> var1);

    abstract boolean verify();

    static <T> Symbol<T> createSymbolInstanceUnsafe(ByteSequence byteSequence) {
        if (byteSequence instanceof Symbol) {
            Symbol symbol = (Symbol)byteSequence;
            return symbol;
        }
        byte[] rawBytes = Arrays.copyOfRange(byteSequence.getUnderlyingBytes(), byteSequence.offset(), byteSequence.offset() + byteSequence.length());
        return new Symbol(rawBytes, byteSequence.hashCode());
    }

    public static class TestHelper {
        public static <T> Symbol<T> lookup(Symbols symbols, ByteSequence byteSequence) {
            return symbols.lookup(byteSequence);
        }

        public static <T> Symbol<T> lookup(Symbols symbols, String string) {
            return symbols.lookup(string);
        }

        public static <T> Symbol<T> getOrCreate(Symbols symbols, ByteSequence byteSequence) {
            return symbols.getOrCreate(byteSequence);
        }

        public static <T> Symbol<T> getOrCreate(Symbols symbols, ByteSequence byteSequence, boolean returnStrongSymbol) {
            return symbols.getOrCreate(byteSequence, returnStrongSymbol);
        }

        public static boolean isWeak(Symbols symbols, Symbol<?> symbol) {
            return symbols.isWeak(symbol);
        }

        public static boolean verify(Symbols symbols) {
            return symbols.verify();
        }
    }
}

