/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.ModifiedUTF8;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;
import com.oracle.svm.espresso.classfile.descriptors.Validation;

public final class Utf8Symbols {
    private final Symbols symbols;

    public Utf8Symbols(Symbols symbols) {
        this.symbols = symbols;
    }

    public Symbol<? extends ModifiedUTF8> lookupValidUtf8(ByteSequence byteSequence) {
        if (Validation.validModifiedUTF8(byteSequence)) {
            return this.symbols.lookup(byteSequence);
        }
        return null;
    }

    public Symbol<? extends ModifiedUTF8> lookupValidUtf8(String string) {
        return this.lookupValidUtf8(ByteSequence.create(string));
    }

    public Symbol<? extends ModifiedUTF8> getOrCreateValidUtf8(String string) {
        return this.getOrCreateValidUtf8(ByteSequence.create(string));
    }

    public Symbol<? extends ModifiedUTF8> getOrCreateValidUtf8(ByteSequence byteSequence) {
        return this.getOrCreateValidUtf8(byteSequence, false);
    }

    public Symbol<? extends ModifiedUTF8> getOrCreateValidUtf8(ByteSequence byteSequence, boolean ensureStrongReference) {
        if (Validation.validModifiedUTF8(byteSequence)) {
            return this.symbols.getOrCreate(byteSequence, ensureStrongReference);
        }
        return null;
    }
}

