/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;

final class ReferenceVariable
extends VerificationTypeInfo {
    private final int constantPoolOffset;

    ReferenceVariable(int constantPoolOffset) {
        this.constantPoolOffset = constantPoolOffset;
    }

    @Override
    public int getTag() {
        return 7;
    }

    @Override
    public int getConstantPoolOffset() {
        return this.constantPoolOffset;
    }

    @Override
    protected String fromCP(ConstantPool pool) {
        return String.valueOf(pool.className(this.constantPoolOffset));
    }

    @Override
    public Symbol<Type> getType(ConstantPool pool, TypeSymbols types, BytecodeStream bs) {
        return types.fromClassNameEntry(pool.className(this.getConstantPoolOffset()));
    }
}

