/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.JDWP;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.server.api.ConnectionController;
import com.oracle.svm.jdwp.server.api.VMEventListener;
import com.oracle.svm.jdwp.server.impl.EventFilters;
import com.oracle.svm.jdwp.server.impl.JDWPContext;
import com.oracle.svm.jdwp.server.impl.RequestedJDWPEvents;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.VMEventListenerImpl;

public final class DebuggerController {
    private final long initialThreadId;
    private final ConnectionController connectionController;
    private final JDWPContext context;
    private final EventFilters eventFilters;
    private final VMEventListener eventListener;
    private final RequestedJDWPEvents requestedJDWPEvents;
    private final JDWP serverJDWPImpl;

    public DebuggerController(long initialThreadId, ConnectionController connectionController) {
        this.initialThreadId = initialThreadId;
        this.connectionController = connectionController;
        this.context = new JDWPContext();
        this.eventListener = new VMEventListenerImpl();
        this.eventFilters = new EventFilters();
        this.requestedJDWPEvents = new RequestedJDWPEvents(this);
        this.serverJDWPImpl = new ServerJDWP(this);
    }

    void init() {
        ((VMEventListenerImpl)this.eventListener).activate(this.initialThreadId, this.context);
    }

    public VMEventListener getEventListener() {
        return this.eventListener;
    }

    JDWPContext getContext() {
        return this.context;
    }

    public EventFilters getEventFilters() {
        return this.eventFilters;
    }

    RequestedJDWPEvents getRequestedJDWPEvents() {
        return this.requestedJDWPEvents;
    }

    public JDWP getServerJDWP() {
        return this.serverJDWPImpl;
    }

    void clearBreakpoints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void disposeDebugger(Packet replyPacket) {
        this.eventListener.setConnection(null);
        this.connectionController.dispose(replyPacket);
        this.eventListener.disposeAllRequests();
        this.context.getThreadsCollector().releaseAllThreadsAndDispose();
        this.connectionController.restart();
    }

    void disposeConnection(Packet replyPacket) {
        this.connectionController.dispose(replyPacket);
    }
}

