/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.server.impl.AbstractBreakpointInfo;
import com.oracle.svm.jdwp.server.impl.Breakpoints;
import com.oracle.svm.jdwp.server.impl.RequestFilter;

public final class LineBreakpointInfo
extends AbstractBreakpointInfo {
    private final byte typeTag;
    private final long classId;
    private final long methodId;
    private final long bci;

    public LineBreakpointInfo(RequestFilter filter, Breakpoints breakpoints, byte tag, long classId, long methodId, long bci) {
        super(filter, breakpoints);
        this.typeTag = tag;
        this.classId = classId;
        this.methodId = methodId;
        this.bci = bci;
    }

    @Override
    public boolean matches(long matchingClassId, long matchingMethodId, int matchingBci) {
        return this.methodId == matchingMethodId && this.bci == (long)matchingBci;
    }

    @Override
    public long getClassId() {
        return this.classId;
    }

    @Override
    public long getMethodId() {
        return this.methodId;
    }

    @Override
    public long getBci() {
        return this.bci;
    }

    public String toString() {
        return "typeTag: " + this.typeTag + ", classId: " + this.classId + ", methodId: " + this.methodId + ", bci: " + this.bci;
    }
}

